/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PegBoard;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.HashSet;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Test;

public class BMLBlockTest {
    @Mocked
    BMLScheduler mockScheduler;

    @Test
    public void testFeedbackOnEmpty() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        PegBoard pegBoard = new PegBoard();
        HashSet<String> behs = new HashSet<String>();
        behs.add("beh1");
        new NonStrictExpectations(pegBoard, behs){
            {
                BMLBlockTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 1;
                BMLBlockTest.this.mockScheduler.getEndTime("beh1", "bml1");
                this.returns(-1.7976931348623157E308);
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
                minTimes = 1;
            }
        };
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "start", 1.0, 1.0);
        bbm.syncProgress(spp);
    }

    @Test
    public void testFeedbackGiven1() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        PegBoard pegBoard = new PegBoard();
        TimePeg tp1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp1.setGlobalValue(1.0);
        pegBoard.addTimePeg("start", "beh1", "bml1", tp1);
        TimePeg tp3 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp3.setGlobalValue(2.0);
        pegBoard.addTimePeg("stroke", "beh1", "bml1", tp3);
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        pegBoard.addTimePeg("end", "beh1", "bml1", tp2);
        TimePeg tp4 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp4.setGlobalValue(1.0);
        pegBoard.addTimePeg("stroke", "beh2", "bml1", tp4);
        pegBoard.addTimePeg("end", "beh2", "bml1", tp3);
        TimePeg tp6 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp6.setGlobalValue(6.0);
        pegBoard.addTimePeg("start", "beh1", "bml2", tp6);
        HashSet<String> behs = new HashSet<String>();
        behs.add("beh1");
        behs.add("beh2");
        new NonStrictExpectations(pegBoard, behs){
            {
                BMLBlockTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 1;
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
                BMLBlockTest.this.mockScheduler.getEndTime("beh1", "bml1");
                this.returns(-1.7976931348623157E308);
                minTimes = 1;
                BMLBlockTest.this.mockScheduler.getEndTime("beh2", "bml1");
                this.returns(-1.7976931348623157E308);
                minTimes = 1;
            }
        };
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "start", 1.0, 1.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb3", "bml1", "beh2", "stroke", 1.1, 1.1);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb2", "bml1", "beh1", "stroke", 2.0, 2.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb4", "bml1", "beh2", "end", 2.0, 2.0);
        bbm.syncProgress(spp);
    }

    @Test
    public void testFeedbackNotGiven1() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        PegBoard pegBoard = new PegBoard();
        TimePeg tp1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp1.setGlobalValue(1.0);
        pegBoard.addTimePeg("start", "beh1", "bml1", tp1);
        TimePeg tp3 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp3.setGlobalValue(2.0);
        pegBoard.addTimePeg("stroke", "beh1", "bml1", tp3);
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        pegBoard.addTimePeg("end", "beh1", "bml1", tp2);
        TimePeg tp4 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp4.setGlobalValue(1.0);
        pegBoard.addTimePeg("stroke", "beh2", "bml1", tp4);
        pegBoard.addTimePeg("end", "beh2", "bml1", tp3);
        TimePeg tp6 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp6.setGlobalValue(6.0);
        pegBoard.addTimePeg("start", "beh1", "bml2", tp6);
        HashSet<String> behs = new HashSet<String>();
        behs.add("beh1");
        behs.add("beh2");
        new NonStrictExpectations(pegBoard, behs){
            {
                BMLBlockTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 0;
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
            }
        };
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "start", 1.0, 1.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb3", "bml1", "beh2", "stroke", 1.5, 1.5);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb4", "bml1", "beh2", "end", 2.0, 2.0);
        bbm.syncProgress(spp);
    }

    @Test
    public void testNoFeedbackOnEnd() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        PegBoard pegBoard = new PegBoard();
        TimePeg tp1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp1.setGlobalValue(1.0);
        pegBoard.addTimePeg("start", "beh1", "bml1", tp1);
        HashSet<String> behs = new HashSet<String>();
        behs.add("beh1");
        new NonStrictExpectations(pegBoard, behs){
            {
                BMLBlockTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 0;
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
                BMLBlockTest.this.mockScheduler.getEndTime("beh1", "bml1");
                this.returns(4.0);
            }
        };
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "start", 4.0, 4.0);
        bbm.syncProgress(spp);
    }

    @Test
    public void testFeedbackOnEnd() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        PegBoard pegBoard = new PegBoard();
        TimePeg tp1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp1.setGlobalValue(1.0);
        pegBoard.addTimePeg("start", "beh1", "bml1", tp1);
        HashSet<String> behs = new HashSet<String>();
        behs.add("beh1");
        new NonStrictExpectations(pegBoard, behs){
            {
                BMLBlockTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 1;
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
                BMLBlockTest.this.mockScheduler.getEndTime("beh1", "bml1");
                this.returns(4.0);
            }
        };
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "start", 1.0, 1.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "end", 4.0, 4.0);
        bbm.syncProgress(spp);
    }

    @Test
    public void testTwoBehaviours() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        PegBoard pegBoard = new PegBoard();
        TimePeg tp1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp1.setGlobalValue(1.0);
        pegBoard.addTimePeg("start", "beh1", "bml1", tp1);
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp2.setGlobalValue(2.0);
        pegBoard.addTimePeg("start", "beh2", "bml1", tp2);
        HashSet<String> behs = new HashSet<String>();
        behs.add("beh1");
        behs.add("beh2");
        new NonStrictExpectations(pegBoard, behs){
            {
                BMLBlockTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 1;
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
                BMLBlockTest.this.mockScheduler.getEndTime("beh1", "bml1");
                this.returns(4.0);
                BMLBlockTest.this.mockScheduler.getEndTime("beh2", "bml1");
                this.returns(8.0);
            }
        };
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "start", 1.0, 1.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb2", "bml1", "beh2", "start", 3.0, 3.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb3", "bml1", "beh1", "end", 4.0, 4.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb4", "bml1", "beh2", "end", 8.0, 8.0);
        bbm.syncProgress(spp);
    }

    @Test
    public void testFeedbackOnException() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        new NonStrictExpectations(){
            {
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(new HashSet());
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 1;
            }
        };
        bbm.exception(new BMLExceptionFeedback("w1", "bml1", 0.0, new HashSet(), new HashSet(), "", false));
    }

    @Test
    public void testTwoBehavioursReverse() {
        BMLBlock bbm = new BMLBlock("bml1", this.mockScheduler);
        PegBoard pegBoard = new PegBoard();
        TimePeg tp1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp1.setGlobalValue(1.0);
        pegBoard.addTimePeg("start", "beh2", "bml1", tp1);
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp2.setGlobalValue(2.0);
        pegBoard.addTimePeg("start", "beh1", "bml1", tp2);
        HashSet<String> behs = new HashSet<String>();
        behs.add("beh1");
        behs.add("beh2");
        new NonStrictExpectations(pegBoard, behs){
            {
                BMLBlockTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                BMLBlockTest.this.mockScheduler.blockStopFeedback("bml1");
                times = 1;
                BMLBlockTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
                BMLBlockTest.this.mockScheduler.getEndTime("beh2", "bml1");
                this.returns(4.0);
                BMLBlockTest.this.mockScheduler.getEndTime("beh1", "bml1");
                this.returns(8.0);
            }
        };
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh2", "start", 1.0, 1.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb2", "bml1", "beh1", "start", 3.0, 3.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb3", "bml1", "beh2", "end", 4.0, 4.0);
        bbm.syncProgress(spp);
        spp = new BMLSyncPointProgressFeedback("fb4", "bml1", "beh1", "end", 8.0, 8.0);
        bbm.syncProgress(spp);
    }

    @Test
    public void testUpdate() {
        BMLBlockManager bbm = new BMLBlockManager();
        HashSet<String> appendAfter = new HashSet<String>();
        appendAfter.add("bml2");
        appendAfter.add("bml3");
        bbm.addBMLBlock(new BMLBlock("bml1", this.mockScheduler, appendAfter, new HashSet<String>()));
        bbm.addBMLBlock(new BMLBlock("bml2", this.mockScheduler));
        bbm.addBMLBlock(new BMLBlock("bml3", this.mockScheduler));
        bbm.setBMLBlockState("bml1", TimedPlanUnitState.LURKING);
        bbm.setBMLBlockState("bml2", TimedPlanUnitState.IN_EXEC);
        bbm.setBMLBlockState("bml3", TimedPlanUnitState.IN_EXEC);
        new NonStrictExpectations(){
            {
                BMLBlockTest.this.mockScheduler.startBlock("bml1");
                times = 1;
                BMLBlockTest.this.mockScheduler.startBlock("bml2");
                times = 0;
                BMLBlockTest.this.mockScheduler.startBlock("bml3");
                times = 0;
            }
        };
        bbm.performanceStop(new BMLPerformanceStopFeedback("fb1", "bml2", "", 1.0));
        bbm.performanceStop(new BMLPerformanceStopFeedback("fb2", "bml3", "", 1.0));
    }

    @Test
    public void testUpdateRemoved() {
        BMLBlockManager bbm = new BMLBlockManager();
        HashSet<String> appendAfter = new HashSet<String>();
        appendAfter.add("bml2");
        appendAfter.add("bml3");
        bbm.addBMLBlock(new BMLBlock("bml1", this.mockScheduler, appendAfter, new HashSet<String>()));
        bbm.addBMLBlock(new BMLBlock("bml2", this.mockScheduler));
        bbm.addBMLBlock(new BMLBlock("bml3", this.mockScheduler));
        bbm.setBMLBlockState("bml1", TimedPlanUnitState.LURKING);
        bbm.setBMLBlockState("bml2", TimedPlanUnitState.IN_EXEC);
        bbm.setBMLBlockState("bml3", TimedPlanUnitState.IN_EXEC);
        new NonStrictExpectations(){
            {
                BMLBlockTest.this.mockScheduler.startBlock("bml1");
                times = 1;
                BMLBlockTest.this.mockScheduler.startBlock("bml2");
                times = 0;
                BMLBlockTest.this.mockScheduler.startBlock("bml3");
                times = 0;
            }
        };
        bbm.performanceStop(new BMLPerformanceStopFeedback("fb1", "bml2", "", 1.0));
        bbm.removeBMLBlock("bml3");
    }

    @Test
    public void testNotUpdate() {
        BMLBlockManager bbm = new BMLBlockManager();
        HashSet<String> appendAfter = new HashSet<String>();
        appendAfter.add("bml2");
        appendAfter.add("bml3");
        bbm.addBMLBlock(new BMLBlock("bml1", this.mockScheduler, appendAfter, new HashSet<String>()));
        bbm.addBMLBlock(new BMLBlock("bml2", this.mockScheduler));
        bbm.addBMLBlock(new BMLBlock("bml3", this.mockScheduler));
        bbm.setBMLBlockState("bml1", TimedPlanUnitState.PENDING);
        bbm.setBMLBlockState("bml2", TimedPlanUnitState.IN_EXEC);
        bbm.setBMLBlockState("bml3", TimedPlanUnitState.IN_EXEC);
        new NonStrictExpectations(){
            {
                BMLBlockTest.this.mockScheduler.startBlock("bml1");
                times = 0;
                BMLBlockTest.this.mockScheduler.startBlock("bml2");
                times = 0;
                BMLBlockTest.this.mockScheduler.startBlock("bml3");
                times = 0;
            }
        };
        bbm.performanceStop(new BMLPerformanceStopFeedback("fb1", "bml2", "", 1.0));
    }
}

