/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.HashSet;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BMLBlockManagerTest {
    @Mocked
    BMLScheduler mockScheduler;

    @Before
    public void setup() {
        HashSet<String> bml1Behs = new HashSet<String>();
        bml1Behs.add("beh1");
        HashSet<String> beh1Syncs = new HashSet<String>();
        beh1Syncs.add("s1");
        new NonStrictExpectations(bml1Behs, beh1Syncs){
            {
                BMLBlockManagerTest.this.mockScheduler.getBehaviours("bml1");
                this.returns(set);
                BMLBlockManagerTest.this.mockScheduler.getTimedSyncs("beh1", "bml1");
                this.returns(set2);
            }
        };
    }

    @Test
    public void testGetBMLBlocks() {
        BMLBlockManager bbm = new BMLBlockManager();
        BMLBlock bb1 = new BMLBlock("bml1", this.mockScheduler);
        BMLBlock bb2 = new BMLBlock("bml2", this.mockScheduler);
        bbm.addBMLBlock(bb1);
        bbm.addBMLBlock(bb2);
        Assert.assertTrue((bbm.getBMLBlocks().size() == 2 ? 1 : 0) != 0);
        Assert.assertThat(bbm.getBMLBlocks(), (Matcher)IsCollectionContaining.hasItem((Object)"bml1"));
        Assert.assertThat(bbm.getBMLBlocks(), (Matcher)IsCollectionContaining.hasItem((Object)"bml2"));
    }

    @Test
    public void testSetState() {
        BMLBlockManager bbm = new BMLBlockManager();
        BMLBlock bb1 = new BMLBlock("bml1", this.mockScheduler);
        bbm.addBMLBlock(bb1);
        bbm.setBMLBlockState("bml1", TimedPlanUnitState.IN_EXEC);
        Assert.assertEquals((Object)((Object)TimedPlanUnitState.IN_EXEC), (Object)((Object)bbm.getBMLBlockState("bml1")));
    }

    @Test
    public void testActivate() {
        BMLBlockManager bbm = new BMLBlockManager();
        BMLBlock bb1 = new BMLBlock("bml1", this.mockScheduler);
        bbm.addBMLBlock(bb1);
        bbm.setBMLBlockState("bml1", TimedPlanUnitState.PENDING);
        bbm.activate("bml1", 0.0);
        Assert.assertEquals((Object)((Object)TimedPlanUnitState.LURKING), (Object)((Object)bbm.getBMLBlockState("bml1")));
    }

    @Test
    public void testActivateRunning() {
        BMLBlockManager bbm = new BMLBlockManager();
        BMLBlock bb1 = new BMLBlock("bml1", this.mockScheduler);
        bbm.addBMLBlock(bb1);
        bbm.setBMLBlockState("bml1", TimedPlanUnitState.IN_EXEC);
        bbm.activate("bml1", 0.0);
        Assert.assertEquals((Object)((Object)TimedPlanUnitState.IN_EXEC), (Object)((Object)bbm.getBMLBlockState("bml1")));
    }

    @Test
    public void testRemove() {
        BMLBlockManager bbm = new BMLBlockManager();
        BMLBlock bb1 = new BMLBlock("bml1", this.mockScheduler);
        BMLBlock bb2 = new BMLBlock("bml2", this.mockScheduler);
        bbm.addBMLBlock(bb1);
        bbm.addBMLBlock(bb2);
        bbm.removeBMLBlock("bml1");
        Assert.assertEquals((long)1L, (long)bbm.getBMLBlocks().size());
        Assert.assertThat(bbm.getBMLBlocks(), (Matcher)IsCollectionContaining.hasItem((Object)"bml2"));
    }

    @Test
    public void testProgress() {
        BMLBlockManager bbm = new BMLBlockManager();
        bbm.syncProgress(new BMLSyncPointProgressFeedback("spp1", "bml1", "beh1", "start", 0.0, 0.0));
        bbm.syncProgress(new BMLSyncPointProgressFeedback("spp2", "bml1", "beh1", "stroke", 1.0, 1.0));
        bbm.syncProgress(new BMLSyncPointProgressFeedback("spp3", "bml2", "beh2", "start", 2.0, 2.0));
        Assert.assertEquals((long)2L, (long)bbm.getSyncsPassed("bml1", "beh1").size());
        Assert.assertThat(bbm.getSyncsPassed("bml1", "beh1"), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"start", "stroke"}));
        Assert.assertEquals((long)1L, (long)bbm.getSyncsPassed("bml2", "beh2").size());
        Assert.assertThat(bbm.getSyncsPassed("bml2", "beh2"), (Matcher)IsCollectionContaining.hasItem((Object)"start"));
    }

    @Test
    public void testProgressReset() {
        BMLBlockManager bbm = new BMLBlockManager();
        bbm.syncProgress(new BMLSyncPointProgressFeedback("spp1", "bml1", "beh1", "start", 0.0, 0.0));
        bbm.syncProgress(new BMLSyncPointProgressFeedback("spp2", "bml1", "beh1", "stroke", 1.0, 1.0));
        bbm.syncProgress(new BMLSyncPointProgressFeedback("spp3", "bml2", "beh2", "start", 2.0, 2.0));
        bbm.reset();
        Assert.assertEquals((long)0L, (long)bbm.getSyncsPassed("bml1", "beh1").size());
        Assert.assertEquals((long)0L, (long)bbm.getSyncsPassed("bml2", "beh2").size());
    }
}

