/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMLBlockManager
implements BMLFeedbackListener {
    private final ConcurrentHashMap<String, BMLBlock> finishedBMLBlocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BMLBlock> BMLBlocks = new ConcurrentHashMap();
    private final Logger logger = LoggerFactory.getLogger((String)BMLScheduler.class.getName());
    private final SetMultimap<BehaviorKey, BMLSyncPointProgressFeedback> behaviorProgress;

    public BMLBlockManager() {
        HashMultimap behaviorProgressMap = HashMultimap.create();
        this.behaviorProgress = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create((Multimap)behaviorProgressMap));
    }

    public void addBMLBlock(BMLBlock bbm) {
        this.BMLBlocks.put(bbm.getBMLId(), bbm);
    }

    public void removeBMLBlock(String bmlId) {
        this.BMLBlocks.remove(bmlId);
        this.finishedBMLBlocks.remove(bmlId);
        this.updateBlocks();
    }

    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        BMLBlock b = this.BMLBlocks.get(bmlId);
        if (b != null) {
            b.setState(state);
        }
    }

    public void startBlock(String bmlId) {
        this.setBMLBlockState(bmlId, TimedPlanUnitState.IN_EXEC);
    }

    public void activateOnStartBlocks(String bmlId, double time) {
        BMLBlock b = this.BMLBlocks.get(bmlId);
        if (b == null) {
            this.logger.warn("Attempting to activate onStart of non-existing BML block {}", (Object)bmlId);
            return;
        }
        for (String onStart : b.getOnStartSet()) {
            this.activate(onStart, time);
        }
    }

    public TimedPlanUnitState getBMLBlockState(String bmlId) {
        BMLBlock b = this.BMLBlocks.get(bmlId);
        if (b == null) {
            return TimedPlanUnitState.DONE;
        }
        return b.getState();
    }

    public Set<String> getBMLBlocks() {
        HashSet<String> bmlBlocks = new HashSet<String>();
        for (String bmlId : this.BMLBlocks.keySet()) {
            bmlBlocks.add(bmlId);
        }
        return bmlBlocks;
    }

    void updateBlocks() {
        for (BMLBlock blockMan : this.BMLBlocks.values()) {
            blockMan.update(this.finishedBMLBlocks.keySet(), this.BMLBlocks.keySet());
        }
    }

    void updateBlocks(double time) {
        for (BMLBlock blockMan : this.BMLBlocks.values()) {
            blockMan.updateState(time);
            blockMan.update(this.finishedBMLBlocks.keySet(), this.BMLBlocks.keySet());
        }
    }

    public void clear() {
        for (BMLBlock block : this.BMLBlocks.values()) {
            block.clear();
        }
        this.finishedBMLBlocks.clear();
        this.BMLBlocks.clear();
        this.behaviorProgress.clear();
    }

    public void activate(String bmlId, double time) {
        BMLBlock bb = this.BMLBlocks.get(bmlId);
        if (bb == null) {
            this.logger.warn("Attempting to activate unknown block {}", (Object)bmlId);
            return;
        }
        if (bb.getState() == TimedPlanUnitState.PENDING) {
            bb.setState(TimedPlanUnitState.LURKING);
        }
        this.updateBlocks(time);
    }

    public void performanceStop(BMLPerformanceStopFeedback psf) {
        BMLBlock blockMan = this.BMLBlocks.get(psf.bmlId);
        if (blockMan == null) {
            return;
        }
        this.finishedBMLBlocks.put(psf.bmlId, blockMan);
        this.updateBlocks();
    }

    public void reset() {
        this.behaviorProgress.clear();
    }

    public void performanceStart(BMLPerformanceStartFeedback psf) {
        this.updateBlocks();
    }

    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        this.behaviorProgress.put((Object)new BehaviorKey(spp.behaviorId, spp.bmlId), (Object)spp);
        this.logger.debug("Adding sync {}:{}:{} to behaviorProgress", (Object[])new String[]{spp.bmlId, spp.behaviorId, spp.syncId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<BMLSyncPointProgressFeedback> getSyncProgress(String bmlId, String behaviorId) {
        SetMultimap<BehaviorKey, BMLSyncPointProgressFeedback> setMultimap = this.behaviorProgress;
        synchronized (setMultimap) {
            return ImmutableSet.copyOf((Iterable)this.behaviorProgress.get((Object)new BehaviorKey(behaviorId, bmlId)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<String> getSyncsPassed(String bmlId, String behaviorId) {
        HashSet<String> progress = new HashSet<String>();
        SetMultimap<BehaviorKey, BMLSyncPointProgressFeedback> setMultimap = this.behaviorProgress;
        synchronized (setMultimap) {
            Set sppf = this.behaviorProgress.get((Object)new BehaviorKey(behaviorId, bmlId));
            for (BMLSyncPointProgressFeedback spp : sppf) {
                progress.add(spp.syncId);
            }
        }
        return ImmutableSet.copyOf(progress);
    }

    private static class BehaviorKey {
        final String id;
        final String bmlId;

        public BehaviorKey(String id, String bmlId) {
            this.id = id;
            this.bmlId = bmlId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BehaviorKey)) {
                return false;
            }
            BehaviorKey pk = (BehaviorKey)o;
            return pk.bmlId.equals(this.bmlId) && pk.id.equals(this.id);
        }

        public int hashCode() {
            return 17 + this.id.hashCode() * 31 + this.bmlId.hashCode() * 31 * 31;
        }
    }
}

