/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.bml.BMLSync;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.RelativeSyncNotFoundException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedAbstractPlanUnit
implements TimedPlanUnit {
    protected final BMLBlockPeg bmlBlockPeg;
    private boolean subUnit;
    private final String id;
    private final String bmlBlockId;
    private final ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();
    private static Logger logger = LoggerFactory.getLogger((String)TimedAbstractPlanUnit.class.getName());
    private final List<String> availableSyncs = new ArrayList<String>();
    @GuardedBy(value="this")
    private TimedPlanUnitState state;

    public TimedAbstractPlanUnit(BMLBlockPeg bmlPeg, String i, String bmlId, boolean sub) {
        this.bmlBlockPeg = bmlPeg;
        this.id = i;
        this.bmlBlockId = bmlId;
        this.state = TimedPlanUnitState.IN_PREP;
        this.subUnit = sub;
        this.availableSyncs.add(BMLSync.START.getId());
        this.availableSyncs.add(BMLSync.READY.getId());
        this.availableSyncs.add(BMLSync.STROKE_START.getId());
        this.availableSyncs.add(BMLSync.STROKE.getId());
        this.availableSyncs.add(BMLSync.STROKE_END.getId());
        this.availableSyncs.add(BMLSync.RELAX.getId());
        this.availableSyncs.add(BMLSync.END.getId());
    }

    public TimedAbstractPlanUnit(BMLBlockPeg bmlPeg, String i, String bmlId) {
        this(bmlPeg, i, bmlId, false);
    }

    public void setSubUnit(boolean sub) {
        this.subUnit = sub;
    }

    protected abstract void playUnit(double var1) throws TimedPlanUnitPlayException;

    protected abstract void stopUnit(double var1) throws TimedPlanUnitPlayException;

    protected void startUnit(double time) throws TimedPlanUnitPlayException {
    }

    protected void resetUnit() {
    }

    @Override
    public boolean isSubUnit() {
        return this.subUnit;
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public final void play(double time) throws TimedPlanUnitPlayException {
        if (!this.isPlaying()) {
            return;
        }
        logger.debug("playing planunit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
        if (time < this.getStartTime() || this.getStartTime() == -1.7976931348623157E308) {
            if (!this.isSubUnit()) {
                throw new TimedPlanUnitPlayException("Calling play with time :" + time + "< startTime(" + this.getStartTime() + ").", this);
            }
            logger.warn("Calling sub unit play with time : {} < startTime({}).", (Object)time, (Object)this.getStartTime());
        }
        if (time < this.getEndTime() || this.getEndTime() == -1.7976931348623157E308) {
            logger.debug("Entering playUnit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
            this.playUnit(time);
        } else {
            this.stop(time);
        }
    }

    @Override
    public final void reset() {
        switch (this.getState()) {
            case IN_EXEC: 
            case SUBSIDING: 
            case DONE: {
                this.resetUnit();
                this.setState(TimedPlanUnitState.LURKING);
            }
        }
    }

    @Override
    public final void stop(double time) throws TimedPlanUnitPlayException {
        if (this.isPlaying()) {
            this.setState(TimedPlanUnitState.DONE);
            this.stopUnit(time);
        }
    }

    @Override
    public final void start(double time) throws TimedPlanUnitPlayException {
        logger.debug("attempting to start planunit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
        if (!this.isLurking()) {
            return;
        }
        if (time > this.getEndTime() && this.getEndTime() != -1.7976931348623157E308) {
            this.setState(TimedPlanUnitState.DONE);
            if (!this.isSubUnit()) {
                throw new TimedPlanUnitPlayException("Starting behaviour at time " + time + " past end time " + this.getEndTime() + ", behaviour was never executed.", this);
            }
            logger.warn("Starting behaviour {} at time {} past end time {}, behaviour was never executed.", new Object[]{this.getClass().getName(), time, this.getEndTime()});
        } else {
            this.setState(TimedPlanUnitState.IN_EXEC);
            this.startUnit(time);
        }
        logger.debug("started planunit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
    }

    @Override
    public BMLBlockPeg getBMLBlockPeg() {
        return this.bmlBlockPeg;
    }

    @Override
    public String getBMLId() {
        return this.bmlBlockId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void feedback(BMLSyncPointProgressFeedback fb) {
        for (BMLFeedbackListener fbl : this.feedbackListeners) {
            fbl.syncProgress(fb);
        }
    }

    @Override
    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    @Override
    public synchronized void setState(TimedPlanUnitState newState) {
        this.state = newState;
    }

    @Override
    public synchronized TimedPlanUnitState getState() {
        return this.state;
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.state.isPlaying();
    }

    @Override
    public synchronized boolean isLurking() {
        return this.state.isLurking();
    }

    @Override
    public synchronized boolean isDone() {
        return this.state.isDone();
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }

    @Override
    public double getRelativeTime(String syncId) throws RelativeSyncNotFoundException {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return 0.0;
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return 1.0;
        }
        throw new RelativeSyncNotFoundException(syncId);
    }

    @Override
    public double getTime(String syncId) {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return this.getStartTime();
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return this.getEndTime();
        }
        return -1.7976931348623157E308;
    }

    @Override
    public List<String> getAvailableSyncs() {
        return this.availableSyncs;
    }
}

