/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import hmi.elckerlyc.planunit.RelativeSyncNotFoundException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PlanUnitTimeManagerTest {
    PlanUnitTimeManager puTimeManager;
    KeyPositionManager kpManager;

    @Before
    public void setup() {
        this.kpManager = new KeyPositionManagerImpl();
        this.puTimeManager = new PlanUnitTimeManager(this.kpManager);
    }

    @Test
    public void testGetAvailableSyncs() {
        this.kpManager.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.kpManager.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        MatcherAssert.assertThat(this.puTimeManager.getAvailableSyncs(), (Matcher)Matchers.contains((Object[])new String[]{"start", "end"}));
    }

    @Test
    public void testGetRelativeTime() throws RelativeSyncNotFoundException {
        this.kpManager.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.kpManager.addKeyPosition(new KeyPosition("stroke", 0.4, 1.0));
        Assert.assertEquals((double)0.0, (double)this.puTimeManager.getRelativeTime("start"), (double)0.01);
        Assert.assertEquals((double)0.4, (double)this.puTimeManager.getRelativeTime("stroke"), (double)0.01);
    }

    @Test
    public void testGetTimePeg() {
        KeyPosition kpStart = new KeyPosition("start", 0.0, 1.0);
        this.kpManager.addKeyPosition(kpStart);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        this.puTimeManager.setTimePeg(kpStart, tpStart);
        Assert.assertEquals((Object)tpStart, (Object)this.puTimeManager.getTimePeg("start"));
    }

    @Test
    public void testGetUnsetEndTime() {
        Assert.assertEquals((double)-1.7976931348623157E308, (double)this.puTimeManager.getEndTime(), (double)0.001f);
    }

    @Test
    public void testGetEndTime() {
        KeyPosition kpEnd = new KeyPosition("end", 1.0, 1.0);
        this.kpManager.addKeyPosition(kpEnd);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(1.0);
        this.puTimeManager.setTimePeg(kpEnd, tpEnd);
        Assert.assertEquals((double)1.0, (double)this.puTimeManager.getEndTime(), (double)0.001f);
    }
}

