/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.bml.BMLSync;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.planunit.RelativeSyncNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanUnitTimeManager {
    private Map<KeyPosition, TimePeg> pegs = new TreeMap<KeyPosition, TimePeg>();
    private final KeyPositionManager kpManager;
    private static final Logger logger = LoggerFactory.getLogger((String)PlanUnitTimeManager.class.getName());

    public PlanUnitTimeManager(KeyPositionManager kpm) {
        this.kpManager = kpm;
    }

    public void setPegs(Map<KeyPosition, TimePeg> pegs) {
        this.pegs = pegs;
    }

    public double getRelativeTime(String syncId) throws RelativeSyncNotFoundException {
        if (this.kpManager.getKeyPosition(syncId) != null) {
            return this.kpManager.getKeyPosition((String)syncId).time;
        }
        throw new RelativeSyncNotFoundException(syncId);
    }

    public Map<KeyPosition, TimePeg> getPegs() {
        return this.pegs;
    }

    public boolean hasValidTiming() {
        double prevTime = 0.0;
        for (KeyPosition kp : this.pegs.keySet()) {
            TimePeg p = this.pegs.get(kp);
            if (p.getGlobalValue() == -1.7976931348623157E308) continue;
            if (p.getGlobalValue() < prevTime) {
                return false;
            }
            prevTime = p.getGlobalValue();
        }
        return true;
    }

    public KeyPosition getKeyPosition(TimePeg sp) {
        for (KeyPosition kp : this.pegs.keySet()) {
            if (this.pegs.get(kp) == sp) {
                return kp;
            }
            if (this.pegs.get(kp) == sp.getLink()) {
                return kp;
            }
            if (this.pegs.get(kp).getLink() != sp) continue;
            return kp;
        }
        return null;
    }

    public double getPrevPegTime(String pid) {
        KeyPosition kpCur = this.kpManager.getKeyPosition(pid);
        boolean getNext = false;
        BMLSync curSync = BMLSync.get((String)pid);
        ListIterator<KeyPosition> listIter = this.kpManager.getKeyPositions().listIterator(this.kpManager.getKeyPositions().size());
        while (listIter.hasPrevious()) {
            TimePeg tp;
            KeyPosition kp = listIter.previous();
            BMLSync sync = BMLSync.get((String)kp.id);
            if (curSync != null && sync != null && sync.isBefore(curSync)) {
                getNext = true;
            }
            if (getNext && (tp = this.pegs.get(kp)) != null && tp.getGlobalValue() != -1.7976931348623157E308) {
                return tp.getGlobalValue();
            }
            if (kp != kpCur) continue;
            getNext = true;
        }
        return -1.7976931348623157E308;
    }

    public double getNextPegTime(String pid) {
        KeyPosition kpCur = this.kpManager.getKeyPosition(pid);
        boolean getNext = false;
        BMLSync curSync = BMLSync.get((String)pid);
        for (KeyPosition kp : this.pegs.keySet()) {
            TimePeg tp;
            BMLSync sync = BMLSync.get((String)kp.id);
            if (curSync != null && sync != null && sync.isAfter(curSync)) {
                getNext = true;
            }
            if (getNext && (tp = this.pegs.get(kp)) != null && tp.getGlobalValue() != -1.7976931348623157E308) {
                return tp.getGlobalValue();
            }
            if (kp != kpCur) continue;
            getNext = true;
        }
        return -1.7976931348623157E308;
    }

    public double getPegTime(String pid) {
        KeyPosition kp = this.kpManager.getKeyPosition(pid);
        if (kp == null) {
            return -1.7976931348623157E308;
        }
        TimePeg p = this.pegs.get(kp);
        if (p == null) {
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue();
    }

    public TimePeg getTimePeg(String pid) {
        KeyPosition kp = this.kpManager.getKeyPosition(pid);
        if (kp != null) {
            return this.pegs.get(kp);
        }
        return null;
    }

    public double getStartTime() {
        if (this.kpManager.getKeyPosition("start") == null) {
            logger.warn("Null start key on behavior");
            return -1.7976931348623157E308;
        }
        TimePeg tp = this.pegs.get(this.kpManager.getKeyPosition("start"));
        if (tp != null) {
            return tp.getGlobalValue();
        }
        return -1.7976931348623157E308;
    }

    public double getEndTime() {
        if (this.kpManager.getKeyPosition("end") == null) {
            return -1.7976931348623157E308;
        }
        TimePeg tp = this.pegs.get(this.kpManager.getKeyPosition("end"));
        if (tp != null) {
            return tp.getGlobalValue();
        }
        return -1.7976931348623157E308;
    }

    public void setTimePeg(KeyPosition kp, TimePeg sp) {
        this.pegs.put(kp, sp);
    }

    public void setTimePeg(String kid, TimePeg sp) {
        KeyPosition kp = this.kpManager.getKeyPosition(kid);
        this.pegs.put(kp, sp);
    }

    public double getRelativeTime(double absoluteTime) {
        double startSegmentTime = this.getStartTime();
        double startKeyTime = 0.0;
        double endSegmentTime = this.getEndTime();
        double endKeyTime = 1.0;
        for (KeyPosition k : this.pegs.keySet()) {
            TimePeg s = this.pegs.get(k);
            if (s == null || s.getGlobalValue() == -1.7976931348623157E308) continue;
            if (s.getGlobalValue() <= absoluteTime) {
                startSegmentTime = s.getGlobalValue();
                startKeyTime = k.time;
                continue;
            }
            endSegmentTime = s.getGlobalValue();
            endKeyTime = k.time;
            break;
        }
        if (endSegmentTime == -1.7976931348623157E308) {
            return startKeyTime;
        }
        double realDuration = endSegmentTime - startSegmentTime;
        double canDuration = endKeyTime - startKeyTime;
        return (absoluteTime - startSegmentTime) / realDuration * canDuration + startKeyTime;
    }

    public List<String> getAvailableSyncs() {
        ArrayList<String> availableSyncs = new ArrayList<String>();
        for (KeyPosition k : this.kpManager.getKeyPositions()) {
            availableSyncs.add(k.id);
        }
        return availableSyncs;
    }
}

