/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class PlanPlayerTest {
    @Mocked
    TimedPlanUnit mockPlanUnit1;
    @Mocked
    TimedPlanUnit mockPlanUnit2;
    @Mocked
    TimedPlanUnit mockPlanUnit3;

    @Test
    public void testGetEndTime() {
        PlanPlayer pp = new PlanPlayer();
        new NonStrictExpectations(){
            {
                PlanPlayerTest.this.mockPlanUnit1.getEndTime();
                this.returns(3.0);
                PlanPlayerTest.this.mockPlanUnit1.getBMLId();
                this.returns("bml1");
                PlanPlayerTest.this.mockPlanUnit1.getId();
                this.returns("beh1");
            }
        };
        pp.addPlanUnit(this.mockPlanUnit1);
        Assert.assertEquals((double)3.0, (double)pp.getEndTime("beh1", "bml1"), (double)1.0E-4);
        Assert.assertEquals((double)-1.7976931348623157E308, (double)pp.getEndTime("beh2", "bml1"), (double)1.0E-4);
    }

    @Test
    public void testInterruptUnit() {
        PlanPlayer pp = new PlanPlayer();
        new NonStrictExpectations(){
            {
                PlanPlayerTest.this.mockPlanUnit1.getEndTime();
                this.returns(3.0);
                PlanPlayerTest.this.mockPlanUnit1.getBMLId();
                this.returns("bml1");
                PlanPlayerTest.this.mockPlanUnit1.getId();
                this.returns("beh1");
                PlanPlayerTest.this.mockPlanUnit2.getStartTime();
                this.returns(1.0);
                PlanPlayerTest.this.mockPlanUnit2.getEndTime();
                this.returns(4.0);
                PlanPlayerTest.this.mockPlanUnit2.getBMLId();
                this.returns("bml1");
                PlanPlayerTest.this.mockPlanUnit2.getId();
                this.returns("beh2");
                PlanPlayerTest.this.mockPlanUnit3.getStartTime();
                this.returns(0.0);
                PlanPlayerTest.this.mockPlanUnit3.getEndTime();
                this.returns(5.0);
                PlanPlayerTest.this.mockPlanUnit3.getBMLId();
                this.returns("bml2");
                PlanPlayerTest.this.mockPlanUnit3.getId();
                this.returns("beh3");
            }
        };
        pp.addPlanUnit(this.mockPlanUnit1);
        pp.addPlanUnit(this.mockPlanUnit2);
        pp.addPlanUnit(this.mockPlanUnit3);
        Assert.assertEquals((long)3L, (long)pp.getNumberOfPlanUnits());
        pp.interruptBehaviourBlock("bml1", 1.0);
        Assert.assertEquals((long)1L, (long)pp.getNumberOfPlanUnits());
    }
}

