/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyPositionManagerTest {
    private KeyPositionManager kpm;

    @Before
    public void setup() {
        this.kpm = new KeyPositionManagerImpl();
    }

    @Test
    public void testGetPrevPegTime() {
        this.kpm.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.kpm.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        KeyPosition kpStroke = new KeyPosition("stroke", 0.5, 1.0);
        this.kpm.addKeyPosition(kpStroke);
        KeyPosition kpCustom2 = new KeyPosition("custom2", 0.55, 1.0);
        this.kpm.addKeyPosition(kpCustom2);
        KeyPosition kpCustom3 = new KeyPosition("custom3", 0.45, 1.0);
        this.kpm.addKeyPosition(kpCustom3);
        KeyPosition kpCustom = new KeyPosition("custom", 0.6, 1.0);
        this.kpm.addKeyPosition(kpCustom);
        BMLBlockPeg gPeg = new BMLBlockPeg("bml1", 0.3);
        TimePeg tpStroke = new TimePeg(gPeg);
        tpStroke.setGlobalValue(1.0);
        TimePeg tpCustom = new TimePeg(gPeg);
        tpCustom.setGlobalValue(1.2);
        PlanUnitTimeManager put = new PlanUnitTimeManager(this.kpm);
        put.setTimePeg(kpStroke, tpStroke);
        put.setTimePeg(kpCustom, tpCustom);
        double t = put.getPrevPegTime("custom");
        Assert.assertEquals((double)1.0, (double)t, (double)1.0E-4);
        t = put.getPrevPegTime("stroke_end");
        Assert.assertEquals((double)1.0, (double)t, (double)1.0E-4);
        t = put.getPrevPegTime("end");
        Assert.assertEquals((double)1.2, (double)t, (double)1.0E-4);
        TimePeg tpCustom2 = new TimePeg(gPeg);
        tpCustom2.setGlobalValue(1.1);
        put.setTimePeg(kpCustom2, tpCustom2);
        t = put.getPrevPegTime("custom");
        Assert.assertEquals((double)1.1, (double)t, (double)1.0E-4);
        tpStroke.setGlobalValue(-1.7976931348623157E308);
        TimePeg tpCustom3 = new TimePeg(gPeg);
        tpCustom3.setGlobalValue(0.9);
        put.setTimePeg(kpCustom3, tpCustom3);
        t = put.getPrevPegTime("stroke_end");
        Assert.assertEquals((double)0.9, (double)t, (double)1.0E-4);
        t = put.getPrevPegTime("unknown");
        Assert.assertEquals((double)-1.7976931348623157E308, (double)t, (double)1.0E-4);
    }

    @Test
    public void testGetNextPegTime() {
        this.kpm.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.kpm.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        KeyPosition kpStroke = new KeyPosition("stroke", 0.5, 1.0);
        this.kpm.addKeyPosition(kpStroke);
        KeyPosition kpCustom2 = new KeyPosition("custom2", 0.55, 1.0);
        this.kpm.addKeyPosition(kpCustom2);
        KeyPosition kpCustom = new KeyPosition("custom", 0.6, 1.0);
        this.kpm.addKeyPosition(kpCustom);
        BMLBlockPeg gPeg = new BMLBlockPeg("bml1", 0.3);
        TimePeg tpStroke = new TimePeg(gPeg);
        tpStroke.setGlobalValue(1.0);
        TimePeg tpCustom = new TimePeg(gPeg);
        tpCustom.setGlobalValue(1.2);
        PlanUnitTimeManager put = new PlanUnitTimeManager(this.kpm);
        put.setTimePeg(kpStroke, tpStroke);
        put.setTimePeg(kpCustom, tpCustom);
        double t = put.getNextPegTime("stroke");
        Assert.assertEquals((double)1.2, (double)t, (double)1.0E-4);
        t = put.getNextPegTime("stroke_start");
        Assert.assertEquals((double)1.0, (double)t, (double)1.0E-4);
        tpStroke.setGlobalValue(-1.7976931348623157E308);
        t = put.getNextPegTime("stroke_start");
        Assert.assertEquals((double)1.2, (double)t, (double)1.0E-4);
        TimePeg tpCustom2 = new TimePeg(gPeg);
        tpCustom2.setGlobalValue(1.1);
        put.setTimePeg(kpCustom2, tpCustom2);
        t = put.getNextPegTime("custom2");
        Assert.assertEquals((double)1.2, (double)t, (double)1.0E-4);
        t = put.getNextPegTime("unknown");
        Assert.assertEquals((double)-1.7976931348623157E308, (double)t, (double)1.0E-4);
    }
}

