/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.ArrayList;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import org.junit.Assert;
import org.junit.Test;

public class AbstractPlanUnitTest {
    @Test
    public void testSetup() {
        new MockUp<StubPlanUnit>(){

            @Mock(invocations=0)
            double getStartTime() {
                return 0.0;
            }

            @Mock(invocations=1)
            double getEndTime() {
                return 2.0;
            }
        };
        StubPlanUnit apu = new StubPlanUnit(BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        apu.setState(TimedPlanUnitState.LURKING);
        Assert.assertTrue((boolean)apu.isLurking());
        Assert.assertTrue((apu.getEndTime() == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPlayPastEnd() throws TimedPlanUnitPlayException {
        new MockUp<StubPlanUnit>(){

            @Mock
            double getStartTime() {
                return 0.0;
            }

            @Mock
            double getEndTime() {
                return 2.0;
            }

            @Mock(invocations=0)
            protected void playUnit(double time) {
            }

            @Mock(invocations=1)
            protected void stopUnit(double time) {
                Assert.assertTrue((time == 2.0 ? 1 : 0) != 0);
            }
        };
        StubPlanUnit apu = new StubPlanUnit(BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        apu.setState(TimedPlanUnitState.IN_EXEC);
        apu.play(2.0);
        Assert.assertTrue((boolean)apu.isDone());
    }

    @Test
    public void testStart() throws TimedPlanUnitPlayException {
        new MockUp<StubPlanUnit>(){

            @Mock
            double getStartTime() {
                return 0.0;
            }

            @Mock
            double getEndTime() {
                return 2.0;
            }

            @Mock(invocations=1)
            void startUnit(double time) {
                Assert.assertTrue((time == 0.0 ? 1 : 0) != 0);
            }
        };
        StubPlanUnit apu = new StubPlanUnit(BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        apu.setState(TimedPlanUnitState.LURKING);
        apu.start(0.0);
        Assert.assertTrue((apu.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
    }

    @Test
    public void testStartPastEnd() {
        new MockUp<StubPlanUnit>(){

            @Mock
            double getStartTime() {
                return 0.0;
            }

            @Mock
            double getEndTime() {
                return 2.0;
            }

            @Mock(invocations=0)
            void startUnit(double time) {
            }
        };
        StubPlanUnit apu = new StubPlanUnit(BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        apu.setState(TimedPlanUnitState.LURKING);
        boolean ex = false;
        try {
            apu.start(3.0);
        }
        catch (TimedPlanUnitPlayException e) {
            ex = true;
        }
        Assert.assertTrue((boolean)ex);
        Assert.assertTrue((apu.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
    }

    @Test
    public void testPastEnd() throws TimedPlanUnitPlayException {
        new MockUp<StubPlanUnit>(){

            @Mock
            double getStartTime() {
                return 0.0;
            }

            @Mock
            double getEndTime() {
                return 2.0;
            }

            @Mock(invocations=0)
            void playUnit(double time) {
            }
        };
        StubPlanUnit apu = new StubPlanUnit(BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        apu.setState(TimedPlanUnitState.IN_EXEC);
        apu.play(3.0);
        Assert.assertTrue((apu.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
    }

    public void testResetFromPlay() {
        new MockUp<StubPlanUnit>(){

            @Mock
            double getStartTime() {
                return 0.0;
            }

            @Mock
            double getEndTime() {
                return 2.0;
            }
        };
        StubPlanUnit apu = new StubPlanUnit(BMLBlockPeg.GLOBALPEG, "id1", "bml1");
        apu.setState(TimedPlanUnitState.IN_EXEC);
        apu.reset();
        Assert.assertTrue((apu.getState() == TimedPlanUnitState.LURKING ? 1 : 0) != 0);
    }

    private static class StubPlanUnit
    extends TimedAbstractPlanUnit {
        public StubPlanUnit(BMLBlockPeg bmlPeg, String i, String bmlId) {
            super(bmlPeg, i, bmlId);
        }

        @Override
        protected void playUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void startUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        public double getEndTime() {
            return 0.0;
        }

        @Override
        public double getStartTime() {
            return 0.0;
        }

        @Override
        public boolean hasValidTiming() {
            return true;
        }

        @Override
        public double getTime(String syncId) {
            return 0.0;
        }

        @Override
        public TimePeg getTimePeg(String syncId) {
            return null;
        }

        @Override
        public List<String> getAvailableSyncs() {
            return new ArrayList<String>();
        }

        @Override
        public void setTimePeg(String syncId, TimePeg peg) {
        }

        @Override
        public void setParameterValue(String paramId, String value) {
        }

        @Override
        public void setParameterValue(String paramId, float value) {
        }
    }
}

