/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.interrupt;

import com.google.common.collect.ImmutableSet;
import hmi.bml.BMLSync;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.interrupt.InterruptSpec;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedInterruptUnit
extends TimedAbstractPlanUnit {
    private static final Logger logger = LoggerFactory.getLogger((String)TimedInterruptUnit.class.getName());
    private TimePeg startPeg;
    private final BMLScheduler scheduler;
    private final String target;
    private ConcurrentHashMap<String, InterruptSpec> interruptSpecMap = new ConcurrentHashMap();

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
        logger.debug("Setting start peg to {}", (Object)startPeg);
    }

    public TimedInterruptUnit(BMLBlockPeg bmlPeg, String i, String bmlId, String iTarget, BMLScheduler s) {
        super(bmlPeg, i, bmlId);
        this.scheduler = s;
        this.target = iTarget;
        logger.debug("Created interrupt unit {} {} {}", (Object[])new String[]{this.getBMLId(), this.getId(), this.target});
    }

    public void addInterruptSpec(InterruptSpec s) {
        this.interruptSpecMap.put(s.getBehaviour(), s);
    }

    @Override
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("Starting interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        Set<String> stopBehs = this.scheduler.getBehaviours(this.target);
        stopBehs.removeAll(this.interruptSpecMap.keySet());
        for (String beh : stopBehs) {
            logger.debug("Immidiatly interrupting behavior {}:{}", (Object)this.target, (Object)beh);
            this.scheduler.interruptBehavior(beh, this.target);
        }
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke-start", time);
        this.sendFeedback("stroke", time);
    }

    private void sendFeedback(String syncId, double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void playUnit(double time) throws TimedPlanUnitPlayException {
        ConcurrentHashMap<String, InterruptSpec> concurrentHashMap = this.interruptSpecMap;
        synchronized (concurrentHashMap) {
            for (String beh : this.interruptSpecMap.keySet()) {
                if (!this.scheduler.getBehaviours(this.target).contains(beh)) {
                    logger.debug("Behavior {}:{} not planned, prematurely removed from interrupt unit", (Object)this.target, (Object)beh);
                    this.interruptSpecMap.remove(beh);
                    break;
                }
                ImmutableSet<String> syncsFinished = this.scheduler.getSyncsPassed(this.target, beh);
                if (!syncsFinished.contains((Object)this.interruptSpecMap.get(beh).getSyncPoint())) continue;
                logger.debug("Interrupting {}:{}", (Object)this.target, (Object)beh);
                this.scheduler.interruptBehavior(beh, this.target);
                for (String onStartBlock : this.interruptSpecMap.get(beh).getOnStartList()) {
                    this.scheduler.startBlock(onStartBlock);
                }
                this.interruptSpecMap.remove(beh);
            }
            if (this.interruptSpecMap.isEmpty()) {
                this.stop(time);
            }
        }
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        logger.debug("stopping interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        this.sendFeedback("stroke-end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    public double getEndTime() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public boolean hasValidTiming() {
        return true;
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (BMLSync.isBMLSync((String)syncId)) {
            this.startPeg = peg;
        } else {
            logger.warn("Can't set TimePeg for non-BML sync {}", (Object)syncId);
        }
    }

    @Override
    public void setParameterValue(String paramId, String value) {
        logger.warn("Attempting to set value {} to parameter in an InterruptUnit{}:{}", new Object[]{value, paramId, this.getBMLId(), this.getId()});
    }

    @Override
    public void setParameterValue(String paramId, float value) {
        logger.warn("Attempting to set value {} to parameter in an InterruptUnit{}:{}", new Object[]{Float.valueOf(value), paramId, this.getBMLId(), this.getId()});
    }
}

