/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.interrupt;

import hmi.bml.core.Behaviour;
import hmi.bml.ext.bmlt.BMLTInterruptBehaviour;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.interrupt.InterruptPlanner;
import hmi.elckerlyc.interrupt.InterruptPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class InterruptPlannerTest {
    @Mocked
    BMLScheduler mockScheduler;

    @Test
    public void testResolve() throws BehaviourPlanningException {
        InterruptPlanner ip = new InterruptPlanner(new InterruptPlayer(), this.mockScheduler);
        BMLTInterruptBehaviour ipb = new BMLTInterruptBehaviour();
        ipb.readXML("<interrupt xmlns=\"http://hmi.ewi.utwente.nl/bmlt\" target=\"bml3\" id=\"i1\"/>");
        ArrayList<TimePegAndConstraint> sac = new ArrayList<TimePegAndConstraint>();
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        sac.add(new TimePegAndConstraint("start", tp, new Constraint(), 0.0));
        ip.resolveSynchs(BMLBlockPeg.GLOBALPEG, (Behaviour)ipb, sac);
        Assert.assertEquals((double)0.0, (double)tp.getGlobalValue(), (double)1.0E-4);
    }

    @Test
    public void testAdd() throws BehaviourPlanningException {
        InterruptPlanner ip = new InterruptPlanner(new InterruptPlayer(), this.mockScheduler);
        BMLTInterruptBehaviour ipb = new BMLTInterruptBehaviour();
        ipb.readXML("<interrupt xmlns=\"http://hmi.ewi.utwente.nl/bmlt\" target=\"bml3\" id=\"i1\"/>");
        ArrayList<TimePegAndConstraint> sac = new ArrayList<TimePegAndConstraint>();
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        sac.add(new TimePegAndConstraint("start", tp, new Constraint(), 0.0));
        TimedPlanUnit p = ip.resolveSynchs(BMLBlockPeg.GLOBALPEG, (Behaviour)ipb, sac);
        List<SyncAndTimePeg> satp = ip.addBehaviour(BMLBlockPeg.GLOBALPEG, (Behaviour)ipb, sac, p);
        Assert.assertEquals((long)1L, (long)satp.size());
        Assert.assertEquals((Object)tp, (Object)satp.get((int)0).peg);
    }

    @Test
    public void testPlay() throws BehaviourPlanningException {
        InterruptPlanner ip = new InterruptPlanner(new InterruptPlayer(), this.mockScheduler);
        BMLTInterruptBehaviour ipb = new BMLTInterruptBehaviour();
        ipb.readXML("<interrupt xmlns=\"http://hmi.ewi.utwente.nl/bmlt\" target=\"bml3\" id=\"i1\"/>");
        ipb.bmlId = "bml1";
        ArrayList<TimePegAndConstraint> sac = new ArrayList<TimePegAndConstraint>();
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        sac.add(new TimePegAndConstraint("start", tp, new Constraint(), 0.0));
        TimedPlanUnit p = ip.resolveSynchs(BMLBlockPeg.GLOBALPEG, (Behaviour)ipb, sac);
        ip.addBehaviour(BMLBlockPeg.GLOBALPEG, (Behaviour)ipb, sac, p);
        ip.setBMLBlockState("bml1", TimedPlanUnitState.LURKING);
        new NonStrictExpectations(){
            {
                InterruptPlannerTest.this.mockScheduler.getBehaviours("bml3");
                this.returns(new HashSet());
            }
        };
        ip.getInterruptPlayer().play(0.0);
        Assert.assertEquals((Object)((Object)TimedPlanUnitState.DONE), (Object)((Object)p.getState()));
    }
}

