/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine.viseme;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.MorphFU;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.faceengine.viseme.VisemeBinding;
import hmi.elckerlyc.faceengine.viseme.VisemeToMorphMapping;

public class MorphVisemeBinding
implements VisemeBinding {
    private VisemeToMorphMapping visemeMapping;

    public MorphVisemeBinding(VisemeToMorphMapping mapping) {
        this.visemeMapping = mapping;
    }

    @Override
    public TimedFaceUnit getVisemeUnit(BMLBlockPeg bbPeg, Behaviour b, int viseme, double startTime, double peakTime, double endTime, float intensity, FacePlayer player) {
        MorphFU visemeFU = new MorphFU();
        visemeFU.setParameterValue("intensity", intensity);
        if (viseme == -1) {
            viseme = 0;
        }
        String targetName = this.visemeMapping.getMorphTargetForViseme(viseme);
        if (!player.getFaceController().getPossibleFaceMorphTargetNames().contains(targetName)) {
            targetName = "";
        }
        visemeFU.setParameterValue("targetname", targetName);
        TimedFaceUnit tfu = visemeFU.copy(player).createTFU(bbPeg, b.id, b.bmlId);
        if (endTime == startTime) {
            tfu.getKeyPosition((String)"ready").time = 0.5;
            tfu.getKeyPosition((String)"relax").time = 0.5;
        } else {
            tfu.getKeyPosition((String)"ready").time = (peakTime - startTime) / (endTime - startTime);
            tfu.getKeyPosition((String)"relax").time = (peakTime - startTime) / (endTime - startTime);
        }
        return tfu;
    }
}

