/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine.facebinding;

import hmi.bml.core.Behaviour;
import hmi.bml.core.FaceBehaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.facebinding.FaceBinding;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import java.util.List;
import mockit.Mocked;
import org.junit.Assert;
import org.junit.Test;

public class FaceBindingTest {
    @Mocked
    FacePlayer mockFacePlayer;

    @Test
    public void testReadXML() {
        String binding = "<facebinding><FaceUnitSpec type=\"face\"><constraints><constraint name=\"type\" value=\"LEXICALIZED\"/><constraint name=\"lexeme\" value=\"smile\"/></constraints><parametermap><parameter src=\"amount\" dst=\"intensity\"/></parametermap><parameterdefaults><parameterdefault name=\"angle\" value=\"315\"/><parameterdefault name=\"activation\" value=\"1\"/></parameterdefaults><FaceUnit type=\"Plutchik\"/></FaceUnitSpec><FaceUnitSpec type=\"face\"><constraints><constraint name=\"type\" value=\"LEXICALIZED\"/><constraint name=\"lexeme\" value=\"frown\"/></constraints><parametermap><parameter src=\"amount\" dst=\"intensity\"/></parametermap><parameterdefaults><parameterdefault name=\"intensity\" value=\"1\"/><parameterdefault name=\"targetname\" value=\"bodymorpher1\"/></parameterdefaults><FaceUnit type=\"Morph\"/></FaceUnitSpec></facebinding>";
        FaceBinding fb = new FaceBinding();
        fb.readXML(binding);
        FaceBehaviour fbeh = new FaceBehaviour();
        fbeh.readXML("<face amount=\"3\" id=\"face1\" type=\"LEXICALIZED\" lexeme=\"smile\"/>");
        fbeh.bmlId = "bml1";
        BMLBlockPeg bbPeg = new BMLBlockPeg("bml1", 0.3);
        List<TimedFaceUnit> fus = fb.getFaceUnit(bbPeg, (Behaviour)fbeh, this.mockFacePlayer);
        Assert.assertEquals((long)1L, (long)fus.size());
        Assert.assertEquals((Object)fus.get(0).getBMLId(), (Object)"bml1");
        Assert.assertEquals((Object)fus.get(0).getId(), (Object)"face1");
        Assert.assertEquals((double)Double.parseDouble(fus.get(0).getFaceUnit().getParameterValue("angle")), (double)315.0, (double)1.0E-4);
        Assert.assertEquals((double)Double.parseDouble(fus.get(0).getFaceUnit().getParameterValue("activation")), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)Double.parseDouble(fus.get(0).getFaceUnit().getParameterValue("intensity")), (double)3.0, (double)1.0E-4);
    }
}

