/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine.facebinding;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.facebinding.FaceUnitParameterDefault;
import hmi.elckerlyc.faceengine.facebinding.FaceUnitSpec;
import hmi.elckerlyc.faceengine.faceunit.FaceUnit;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.scheduler.SmartBodySchedulingStrategy;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceBinding
extends XMLStructureAdapter {
    private ArrayList<FaceUnitSpec> specs = new ArrayList();
    private Logger logger = LoggerFactory.getLogger((String)SmartBodySchedulingStrategy.class.getName());
    private static final String XMLTAG = "facebinding";

    public List<TimedFaceUnit> getFaceUnit(BMLBlockPeg bbPeg, Behaviour b, FacePlayer player) {
        ArrayList<TimedFaceUnit> fus = new ArrayList<TimedFaceUnit>();
        for (FaceUnitSpec s : this.specs) {
            if (!s.getType().equals(b.getXMLTag()) || (s.getSpecnamespace() != null || b.getNamespace() != null) && (s.getSpecnamespace() == null || !s.getSpecnamespace().equals(b.getNamespace())) || !s.satisfiesConstraints(b)) continue;
            FaceUnit fuCopy = s.faceUnit.copy(player);
            TimedFaceUnit tfu = fuCopy.createTFU(bbPeg, b.id, b.bmlId);
            fus.add(tfu);
            for (FaceUnitParameterDefault fupc : s.getParameterDefaults()) {
                fuCopy.setParameterValue(fupc.name, fupc.value);
                this.logger.debug("Setting parameter {} to default {}", (Object)fupc.name, (Object)fupc.value);
            }
            for (String param : s.getParameters()) {
                if (!b.specifiesParameter(param)) continue;
                String value = b.getStringParameterValue(param);
                fuCopy.setParameterValue(s.getParameter(param), value);
                this.logger.debug("Setting parameter {} mapped to  {}", (Object)param, (Object)s.getParameter(param));
            }
        }
        return fus;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals(FaceUnitSpec.xmlTag())) continue;
            FaceUnitSpec fuSpec = new FaceUnitSpec();
            fuSpec.readXML(tokenizer);
            if (fuSpec.faceUnit != null) {
                this.specs.add(fuSpec);
                continue;
            }
            this.logger.warn("Dropped face unit spec because we could not construct the face unit");
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

