/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.faceengine.faceunit.FUPlayException;
import hmi.elckerlyc.faceengine.faceunit.FaceUnit;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class TimedFaceUnitTest {
    @Mocked
    FaceUnit fuMock;

    @Test
    public void testPrepState() throws TimedPlanUnitPlayException, FUPlayException {
        ArrayList fbList = new ArrayList();
        TimedFaceUnit tfu = new TimedFaceUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.fuMock);
        tfu.addFeedbackListener((BMLFeedbackListener)new ListFeedbackListener(fbList));
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        new NonStrictExpectations(start, end, keyPos){
            {
                TimedFaceUnitTest.this.fuMock.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                TimedFaceUnitTest.this.fuMock.getKeyPosition("end");
                this.returns(keyPosition2);
                TimedFaceUnitTest.this.fuMock.play(anyDouble);
                times = 0;
                TimedFaceUnitTest.this.fuMock.getKeyPositions();
                this.returns(list);
            }
        };
        tfu.setTimePeg("start", tp);
        tfu.play(1.0);
        Assert.assertTrue((boolean)fbList.isEmpty());
    }

    @Test
    public void testPlay() throws TimedPlanUnitPlayException, FUPlayException {
        ArrayList fbList = new ArrayList();
        TimedFaceUnit tfu = new TimedFaceUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.fuMock);
        tfu.addFeedbackListener((BMLFeedbackListener)new ListFeedbackListener(fbList));
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(1.0);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        new NonStrictExpectations(keyPos, end, start){
            {
                TimedFaceUnitTest.this.fuMock.play(0.5);
                times = 1;
                TimedFaceUnitTest.this.fuMock.getKeyPositions();
                this.returns(list);
                TimedFaceUnitTest.this.fuMock.getKeyPosition("end");
                this.returns(keyPosition);
                TimedFaceUnitTest.this.fuMock.getKeyPosition("start");
                this.returns(keyPosition2);
            }
        };
        tfu.setTimePeg("start", tpStart);
        tfu.setTimePeg("end", tpEnd);
        tfu.setState(TimedPlanUnitState.LURKING);
        tfu.start(0.5);
        tfu.play(0.5);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"behaviour1", (Object)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId);
        Assert.assertEquals((Object)"bml1", (Object)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId);
        Assert.assertEquals((Object)"start", (Object)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId);
        Assert.assertEquals((double)0.5, (double)((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp, (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlBlockTime, (double)1.0E-4);
    }
}

