/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.faceanimation.FaceController;
import hmi.testutil.bml.feedback.ListBMLExceptionListener;
import java.util.ArrayList;
import java.util.List;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FacePlayerTest {
    @Mocked
    private FaceController mockFaceController;
    @Mocked
    private TimedPlanUnit mockPlanUnit;
    @Mocked
    private TimedFaceUnit mockTimedFaceUnit;
    private List<BMLExceptionFeedback> beList;
    private FacePlayer facePlayer;

    @Before
    public void setup() {
        this.facePlayer = new FacePlayer(this.mockFaceController);
        this.beList = new ArrayList<BMLExceptionFeedback>();
        this.facePlayer.addExceptionListener((BMLExceptionListener)new ListBMLExceptionListener(this.beList));
    }

    @Test
    public void testWarning() {
        this.facePlayer.puException(this.mockPlanUnit, "blah", 0.0);
        Assert.assertEquals((long)1L, (long)this.beList.size());
    }

    @Test
    public void testPlanUnitException() throws TimedPlanUnitPlayException {
        this.facePlayer.addTimedFaceUnit(this.mockTimedFaceUnit);
        new NonStrictExpectations(){
            {
                FacePlayerTest.this.mockTimedFaceUnit.getId();
                this.returns("id1");
                FacePlayerTest.this.mockTimedFaceUnit.getBMLId();
                this.returns("bml1");
                FacePlayerTest.this.mockTimedFaceUnit.getStartTime();
                this.returns(0.0);
                FacePlayerTest.this.mockTimedFaceUnit.getEndTime();
                this.returns(1.0);
                FacePlayerTest.this.mockTimedFaceUnit.getState();
                this.returns((Object)TimedPlanUnitState.IN_EXEC);
                FacePlayerTest.this.mockTimedFaceUnit.isPlaying();
                this.returns(true);
                FacePlayerTest.this.mockTimedFaceUnit.play(anyDouble);
                times = 1;
                result = new TimedPlanUnitPlayException("", FacePlayerTest.this.mockTimedFaceUnit);
            }
        };
        Assert.assertEquals((long)1L, (long)this.facePlayer.getBehaviours("bml1").size());
        this.facePlayer.play(0.0);
        Assert.assertEquals((long)1L, (long)this.beList.size());
        Assert.assertEquals((long)0L, (long)this.facePlayer.getBehaviours("bml1").size());
    }
}

