/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.ExceptionManager;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.planunit.PUExceptionCallback;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacePlayer
implements Player,
PUExceptionCallback {
    private static Logger logger = LoggerFactory.getLogger((String)FacePlayer.class.getName());
    private PlanPlayer fpp;
    private FaceController faceController;
    private EmotionConverter emotionConverter;
    private FACSConverter facsConverter;
    private final ExceptionManager warningManager = new ExceptionManager();
    private List<TimedPlanUnit> tmuRemove = new ArrayList<TimedPlanUnit>();

    public FacePlayer(FaceController fc) {
        this(fc, new EmotionConverter(), new FACSConverter());
    }

    public FacePlayer(FaceController fc, EmotionConverter ec, FACSConverter facsc) {
        this.faceController = fc;
        this.emotionConverter = ec;
        this.facsConverter = facsc;
        this.fpp = new PlanPlayer();
    }

    public FaceController getFaceController() {
        return this.faceController;
    }

    public EmotionConverter getEmotionConverter() {
        return this.emotionConverter;
    }

    public FACSConverter getFACSConverter() {
        return this.facsConverter;
    }

    public synchronized void play(double time) {
        this.tmuRemove.clear();
        this.fpp.play(time, this);
        for (TimedPlanUnit tmuR : this.tmuRemove) {
            this.interruptTimedFaceUnit(tmuR.getId(), tmuR.getBMLId(), time);
        }
    }

    public synchronized int getNumberOfTimedFaceUnits() {
        return this.fpp.getNumberOfPlanUnits();
    }

    public synchronized void interruptTimedFaceUnit(String id, String bmlId, double globalTime) {
        this.fpp.interruptPlanUnit(id, bmlId, globalTime);
    }

    public synchronized void addTimedFaceUnit(TimedFaceUnit tfu) {
        this.fpp.addPlanUnit(tfu);
    }

    public synchronized Set<String> getInvalidBehaviors() {
        return this.fpp.getInvalidBehaviors();
    }

    @Override
    public void reset() {
        logger.debug("FacePlayer reset");
    }

    public synchronized void clearAll(double time) {
        this.fpp.clearAll(time);
    }

    @Override
    public void addExceptionListener(BMLExceptionListener ws) {
        this.warningManager.addExceptionListener(ws);
    }

    @Override
    public void removeAllExceptionListeners() {
        this.warningManager.removeAllExceptionListeners();
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.fpp.setBMLBlockState(bmlId, state);
    }

    @Override
    public double getEndTime(String behId, String bmlId) {
        return this.fpp.getEndTime(behId, bmlId);
    }

    @Override
    public Set<String> getBehaviours(String bmlId) {
        return this.fpp.getBehaviours(bmlId);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.fpp.interruptBehaviourBlock(bmlId, time);
    }

    @Override
    public void puException(TimedPlanUnit fmu, String message, double time) {
        this.tmuRemove.add(fmu);
        this.warningManager.puException(fmu, message, time);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        this.fpp.setParameterValue(behId, bmlId, paramId, value);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        this.fpp.setParameterValue(behId, bmlId, paramId, value);
    }

    @Override
    public void shutdown() {
    }
}

