/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.animation.AnimationSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.faceunit.FUPlayException;
import hmi.elckerlyc.faceengine.faceunit.FaceUnit;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.faceanimation.model.FACSConfiguration;
import hmi.faceanimation.model.MPEG4Configuration;
import java.util.List;

public class FACSFU
implements FaceUnit {
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private float intensity = 1.0f;
    private FACSConfiguration facsConfig = new FACSConfiguration();
    private FacePlayer facePlayer;
    private final MPEG4Configuration mpeg4Config = new MPEG4Configuration();

    public FACSFU() {
        KeyPosition ready = new KeyPosition("ready", 0.1, 1.0);
        KeyPosition relax = new KeyPosition("relax", 0.9, 1.0);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        this.addKeyPosition(start);
        this.addKeyPosition(ready);
        this.addKeyPosition(relax);
        this.addKeyPosition(end);
    }

    public void setFacePlayer(FacePlayer fp) {
        this.facePlayer = fp;
    }

    @Override
    public void setParameterValue(String name, float value) {
        if (name.equals("intensity")) {
            this.intensity = value;
        }
    }

    @Override
    public void setParameterValue(String name, String value) {
        this.setParameterValue(name, Float.parseFloat(value));
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("intensity")) {
            return "" + this.intensity;
        }
        return null;
    }

    @Override
    public boolean hasValidParameters() {
        return this.facsConfig != null;
    }

    public void setConfig(FACSConfiguration fc) {
        this.facsConfig = fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double t) throws FUPlayException {
        double ready = this.getKeyPosition((String)"ready").time;
        double relax = this.getKeyPosition((String)"relax").time;
        float newAppliedWeight = 0.0f;
        if (t < ready && t > 0.0) {
            newAppliedWeight = this.intensity * (float)(t / ready);
        } else if (t >= ready && t <= relax) {
            newAppliedWeight = this.intensity;
        } else if (t > relax && t < 1.0) {
            newAppliedWeight = this.intensity * (float)(1.0 - (t - relax) / (1.0 - relax));
        }
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.facePlayer.getFaceController().removeMPEG4Configuration(this.mpeg4Config);
            this.facePlayer.getFACSConverter().convert(this.facsConfig, this.mpeg4Config);
            this.mpeg4Config.multiply(newAppliedWeight);
            this.facePlayer.getFaceController().addMPEG4Configuration(this.mpeg4Config);
        }
    }

    @Override
    public void cleanup() {
        if (this.mpeg4Config != null) {
            this.facePlayer.getFaceController().removeMPEG4Configuration(this.mpeg4Config);
        }
    }

    @Override
    public TimedFaceUnit createTFU(BMLBlockPeg bbPeg, String i, String bmlId) {
        return new TimedFaceUnit(bbPeg, i, bmlId, this);
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public FaceUnit copy(FacePlayer fp) {
        FACSFU result = new FACSFU();
        result.setFacePlayer(fp);
        result.setParameterValue("intensity", this.intensity);
        result.setConfig(this.facsConfig);
        for (KeyPosition keypos : this.getKeyPositions()) {
            result.addKeyPosition(keypos.deepCopy());
        }
        return result;
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

