/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.bridge;

import hmi.bml.bridge.RealizerBridge;
import hmi.bml.feedback.BMLFeedback;
import hmi.bml.feedback.BMLListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.XMLBMLSyncPointProgressFeedback;
import hmi.bml.util.BMLFeedbackManager;
import hmi.elckerlyc.bridge.LoggingRealizerBridge;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.testutil.bml.feedback.FeedbackAsserts;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import java.util.List;
import mockit.Mocked;
import mockit.Verifications;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;

public class LoggingRealizerBridgeTest {
    private LoggingRealizerBridge logBridge;
    private StubInputBridge inputBridge;
    private StubOutputBridge outputBridge;
    private List<BMLSyncPointProgressFeedback> fbList;
    @Mocked
    private SchedulingClock mockSchedulingClock;
    @Mocked
    private Logger mockLogger;

    @Before
    public void setup() {
        this.outputBridge = new StubOutputBridge();
        this.logBridge = new LoggingRealizerBridge(this.mockLogger, this.outputBridge, this.mockSchedulingClock);
        this.inputBridge = new StubInputBridge(this.logBridge);
        this.fbList = new ArrayList<BMLSyncPointProgressFeedback>();
        this.inputBridge.addListeners(new BMLListener[]{new ListFeedbackListener(this.fbList)});
    }

    @Test
    public void testLogBMLRequest() {
        String bml = "<bml id=\"bml1\"/>";
        this.inputBridge.performBML("<bml id=\"bml1\"/>");
        Assert.assertEquals((Object)"<bml id=\"bml1\"/>", (Object)this.outputBridge.getPerformedBML());
        new Verifications(){
            {
                LoggingRealizerBridgeTest.this.mockLogger.info((String)this.withSubstring("<bml id=\"bml1\"/>"));
                times = 1;
            }
        };
    }

    @Test
    public void testLogFeedback() {
        BMLSyncPointProgressFeedback spp = new BMLSyncPointProgressFeedback("fb1", "bml1", "beh1", "sync1", 0.0, 0.0);
        this.outputBridge.sendFeedback((BMLFeedback)spp);
        FeedbackAsserts.assertOneFeedback((BMLSyncPointProgressFeedback)spp, this.fbList);
        String logString = new XMLBMLSyncPointProgressFeedback(spp).toXMLString();
        new Verifications(logString){
            {
                LoggingRealizerBridgeTest.this.mockLogger.info(string);
                times = 1;
            }
        };
    }

    private static class StubInputBridge
    implements RealizerBridge {
        private RealizerBridge outBridge;

        public StubInputBridge(RealizerBridge outBridge) {
            this.outBridge = outBridge;
        }

        public void addListeners(BMLListener ... listeners) {
            this.outBridge.addListeners(listeners);
        }

        public void performBML(String bmlString) {
            this.outBridge.performBML(bmlString);
        }
    }

    private static class StubOutputBridge
    implements RealizerBridge {
        private BMLFeedbackManager feedbackManager = new BMLFeedbackManager();
        private String performedBML;

        private StubOutputBridge() {
        }

        public void sendFeedback(BMLFeedback fb) {
            this.feedbackManager.sendFeedback(fb);
        }

        public String getPerformedBML() {
            return this.performedBML;
        }

        public void addListeners(BMLListener ... bmlListeners) {
            this.feedbackManager.addListeners(bmlListeners);
        }

        public void performBML(String bmlString) {
            this.performedBML = bmlString;
        }
    }
}

