/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.bridge;

import hmi.bml.bridge.RealizerBridge;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningListener;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningStartFeedback;
import hmi.bml.ext.bmlt.feedback.XMLBMLTPlanningFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.XMLBMLTPlanningStartFeedback;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.feedback.XMLBMLExceptionFeedback;
import hmi.bml.feedback.XMLBMLPerformanceStartFeedback;
import hmi.bml.feedback.XMLBMLPerformanceStopFeedback;
import hmi.bml.feedback.XMLBMLSyncPointProgressFeedback;
import hmi.bml.feedback.XMLBMLWarningFeedback;
import hmi.elckerlyc.scheduler.SchedulingClock;
import org.slf4j.Logger;

public class LoggingRealizerBridge
implements RealizerBridge,
BMLFeedbackListener,
BMLExceptionListener,
BMLWarningListener,
BMLTPlanningListener {
    private final Logger logger;
    private final RealizerBridge outputBridge;
    private final SchedulingClock clock;

    public LoggingRealizerBridge(Logger logger, RealizerBridge outBridge, SchedulingClock clock) {
        this.logger = logger;
        this.outputBridge = outBridge;
        this.clock = clock;
        this.outputBridge.addListeners(new BMLListener[]{this});
    }

    public void performanceStop(BMLPerformanceStopFeedback psf) {
        this.logger.info(new XMLBMLPerformanceStopFeedback(psf).toXMLString());
    }

    public void performanceStart(BMLPerformanceStartFeedback psf) {
        this.logger.info(new XMLBMLPerformanceStartFeedback(psf).toXMLString());
    }

    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        this.logger.info(new XMLBMLSyncPointProgressFeedback(spp).toXMLString());
    }

    public void exception(BMLExceptionFeedback be) {
        this.logger.info(new XMLBMLExceptionFeedback(be).toXMLString());
    }

    public void warn(BMLWarningFeedback bw) {
        this.logger.info(new XMLBMLWarningFeedback(bw).toXMLString());
    }

    public void planningFinished(BMLTPlanningFinishedFeedback pff) {
        this.logger.info(new XMLBMLTPlanningFinishedFeedback(pff).toXMLString());
    }

    public void planningStart(BMLTPlanningStartFeedback psf) {
        this.logger.info(new XMLBMLTPlanningStartFeedback(psf).toXMLString());
    }

    public void addListeners(BMLListener ... listeners) {
        this.outputBridge.addListeners(listeners);
    }

    public void performBML(String bmlString) {
        this.logger.info("<entry name=\"{}\" time=\"{}\">", (Object)this.logger.getName(), (Object)this.clock.getTime());
        this.logger.info(bmlString);
        this.logger.info("</entry>");
        this.outputBridge.performBML(bmlString);
    }
}

