/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.audioengine.WavUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import hmi.elckerlyc.audioengine.WavUnitPlayException;
import hmi.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavClipUnit
implements WavUnit {
    private final AudioInputStream audioStream;
    private final AudioFormat audioFormat;
    private final long audioLength;
    private final long audioFrameLength;
    private int audioReadPos = 0;
    private byte[] audioData = null;
    private static final int AUDIO_READ_BUFFER_SIZE = 65535;
    private static final double AUDIOPOSITION_UPDATE_DELTA = 0.066;
    private Clip outputLine;
    private final Object clipLock = new Object();
    public volatile boolean playing = false;
    public volatile boolean stop = false;
    private boolean firstPlay = false;
    private final boolean syncAudio = false;
    private static Logger logger = LoggerFactory.getLogger((String)WavClipUnit.class.getName());

    public WavClipUnit(URL url) throws WavUnitPlanningException {
        try {
            this.audioStream = AudioSystem.getAudioInputStream(url);
        }
        catch (UnsupportedAudioFileException e1) {
            WavUnitPlanningException wupe = new WavUnitPlanningException(e1.getLocalizedMessage(), this);
            wupe.initCause(e1);
            throw wupe;
        }
        catch (IOException e1) {
            WavUnitPlanningException wupe = new WavUnitPlanningException(e1.getLocalizedMessage(), this);
            wupe.initCause(e1);
            throw wupe;
        }
        this.audioFrameLength = this.audioStream.getFrameLength();
        this.audioLength = this.audioStream.getFrameLength() * (long)this.audioStream.getFormat().getFrameSize();
        this.audioData = new byte[(int)this.audioLength];
        this.audioFormat = this.audioStream.getFormat();
        this.audioReadPos = 0;
        while ((long)this.audioReadPos < this.audioLength) {
            long size = 65535L;
            if (size > this.audioLength - (long)this.audioReadPos) {
                size = this.audioLength - (long)this.audioReadPos;
            }
            try {
                this.audioReadPos += this.audioStream.read(this.audioData, this.audioReadPos, (int)size);
            }
            catch (IOException e) {
                WavUnitPlanningException wupe = new WavUnitPlanningException(e.getLocalizedMessage(), this);
                wupe.initCause(e);
                throw wupe;
            }
        }
        try {
            this.audioStream.close();
        }
        catch (IOException e) {
            WavUnitPlanningException wupe = new WavUnitPlanningException(e.getLocalizedMessage(), this);
            wupe.initCause(e);
            throw wupe;
        }
    }

    public double getDuration() {
        logger.debug("WAVUNIT AUDIO FRAME LENGTH: " + this.audioFrameLength);
        logger.debug("WAVUNIT SAMPLERATE: " + this.audioFormat.getSampleRate());
        return (double)this.audioFrameLength / (double)this.audioFormat.getSampleRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameterValue(String parameter, float value) {
        if (this.outputLine == null) {
            logger.warn("Attempting to set parameter: {} value: {} on null output line!", (Object)parameter, (Object)Float.valueOf(value));
            return;
        }
        if (parameter.equals("volume")) {
            Object object = this.clipLock;
            synchronized (object) {
                logger.debug("Setting wav volume");
                FloatControl volume = (FloatControl)this.outputLine.getControl(FloatControl.Type.MASTER_GAIN);
                volume.setValue(value * 6.0f / 100.0f);
            }
        }
    }

    public void setParameterValue(String parameter, String value) {
        if (StringUtil.isNumeric((String)value)) {
            this.setParameterValue(parameter, Float.parseFloat(value));
        }
    }

    @Override
    public void setPlaying(boolean play) {
        this.playing = play;
    }

    @Override
    public void reset() {
        this.stop();
        this.stop = false;
        this.playing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stop = true;
        this.playing = false;
        logger.debug("WavUnit stop");
        Object object = this.clipLock;
        synchronized (object) {
            if (this.outputLine != null) {
                logger.debug("Stop output line");
                this.outputLine.stop();
                this.outputLine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double relTime) throws WavUnitPlayException {
        if (this.stop) {
            return;
        }
        Object object = this.clipLock;
        synchronized (object) {
            if (this.outputLine == null) {
                DataLine.Info info = new DataLine.Info(Clip.class, this.audioFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new WavUnitPlayException("AudioSystem line unsupported for " + info.toString(), this);
                }
                try {
                    this.outputLine = (Clip)AudioSystem.getLine(info);
                    this.outputLine.open(this.audioFormat, this.audioData, 0, this.audioData.length);
                }
                catch (LineUnavailableException ex) {
                    WavUnitPlayException wupe = new WavUnitPlayException(ex.getLocalizedMessage(), this);
                    wupe.initCause(ex);
                    throw wupe;
                }
                this.outputLine.setMicrosecondPosition((long)(relTime * 1000000.0));
                this.outputLine.start();
                this.firstPlay = true;
            } else if (Math.abs((double)this.outputLine.getMicrosecondPosition() * 1.0E-6 - relTime) > 0.066 || this.firstPlay) {
                this.firstPlay = false;
            }
        }
    }
}

