/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.audioengine.TimedAbstractAudioUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AudioUnitTest {
    private ListFeedbackListener feedbackListener;
    private List<BMLSyncPointProgressFeedback> feedbackList;

    @Before
    public void setup() {
        this.feedbackList = new ArrayList<BMLSyncPointProgressFeedback>();
        this.feedbackListener = new ListFeedbackListener(this.feedbackList);
    }

    @Test
    public void testPrepState() throws TimedPlanUnitPlayException {
        new MockUp<StubAudioUnit>(){

            @Mock(invocations=0)
            protected void playUnit(double time) {
            }

            @Mock(invocations=0)
            protected void startUnit(double time) {
            }

            @Mock
            public double getPreferedDuration() {
                return 5.0;
            }
        };
        StubAudioUnit stubAU = new StubAudioUnit(BMLBlockPeg.GLOBALPEG, "dummby", "beh1", "bml1");
        stubAU.addFeedbackListener((BMLFeedbackListener)this.feedbackListener);
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        stubAU.setStart(tp);
        stubAU.start(1.0);
        stubAU.play(1.0);
        Assert.assertTrue((boolean)this.feedbackList.isEmpty());
    }

    @Test
    public void testConstruct() {
        StubAudioUnit stubAU = new StubAudioUnit(BMLBlockPeg.GLOBALPEG, "dummby", "beh1", "bml1");
        Assert.assertEquals((Object)stubAU.getBMLId(), (Object)"bml1");
        Assert.assertEquals((Object)stubAU.getId(), (Object)"beh1");
    }

    @Test
    public void testGetEndTime() {
        StubAudioUnit stubAU = new StubAudioUnit(BMLBlockPeg.GLOBALPEG, "dummby", "beh1", "bml1");
        Assert.assertEquals((double)-1.7976931348623157E308, (double)stubAU.getEndTime(), (double)1.0E-4);
    }

    @Test
    public void testPlay() throws TimedPlanUnitPlayException {
        new MockUp<StubAudioUnit>(){

            @Mock(invocations=1)
            protected void playUnit(double time) {
            }

            @Mock(invocations=1)
            protected void startUnit(double time) {
            }

            @Mock
            public double getPreferedDuration() {
                return 5.0;
            }
        };
        StubAudioUnit stubAU = new StubAudioUnit(BMLBlockPeg.GLOBALPEG, "dummby", "beh1", "bml1");
        stubAU.addFeedbackListener((BMLFeedbackListener)this.feedbackListener);
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        stubAU.setStart(tp);
        stubAU.setState(TimedPlanUnitState.LURKING);
        stubAU.start(1.0);
        Assert.assertEquals((Object)((Object)TimedPlanUnitState.IN_EXEC), (Object)((Object)stubAU.getState()));
        stubAU.play(1.0);
        Assert.assertTrue((boolean)this.feedbackList.isEmpty());
    }

    private static class StubAudioUnit
    extends TimedAbstractAudioUnit {
        public StubAudioUnit(BMLBlockPeg bbPeg, String fname, String id, String bmlId) {
            super(bbPeg, fname, id, bmlId);
        }

        @Override
        public void sendProgress(double playTime, double time) {
        }

        @Override
        public void setParameterValue(String paramater, float value) {
        }

        @Override
        protected void startUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void playUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        public double getPreferedDuration() {
            return 0.0;
        }

        @Override
        public void setParameterValue(String paramId, String value) {
        }
    }
}

