/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.audioengine.AudioPlanPlayer;
import hmi.elckerlyc.audioengine.TimedAbstractAudioUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer
implements Player {
    private final AudioPlanPlayer app = new AudioPlanPlayer();
    private static Logger logger = LoggerFactory.getLogger((String)AudioPlayer.class.getName());

    public void play(double time) {
        this.app.play(time);
    }

    @Override
    public void addExceptionListener(BMLExceptionListener ws) {
        this.app.addExceptionListener(ws);
    }

    @Override
    public void removeAllExceptionListeners() {
        this.app.removeAllExceptionListeners();
    }

    public void addAudioUnit(TimedAbstractAudioUnit au) {
        this.app.addAudioUnit(au);
    }

    public int getNumberOfAudioUnits() {
        return this.app.getNumberOfAudioUnits();
    }

    public void removeAudioUnit(String id, String bmlId) {
        this.app.removeAudioUnit(id, bmlId);
    }

    @Override
    public void reset() {
        this.app.stop();
        logger.debug("AudioPlayer reset");
        this.app.reset();
    }

    @Override
    public void shutdown() {
        try {
            this.app.shutdown();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted Exception when shutting down AudioPlayer", (Throwable)e);
        }
    }

    public void clearAll(double absoluteTime) {
        this.app.clearAll(absoluteTime);
        logger.debug("AudioPlayer cleared");
    }

    public void cleanup() {
        logger.debug("AudioPlayer cleanup");
        this.app.scheduleStop();
    }

    public Set<String> getInvalidBehaviours() {
        return this.app.getInvalidBehaviors();
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.app.setBMLBlockState(bmlId, state);
    }

    @Override
    public double getEndTime(String behId, String bmlId) {
        return this.app.getEndTime(behId, bmlId);
    }

    @Override
    public Set<String> getBehaviours(String bmlId) {
        return this.app.getBehaviours(bmlId);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.app.interruptBehaviourBlock(bmlId, time);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        this.app.setParameterValue(behId, bmlId, paramId, value);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        this.app.setParameterValue(behId, bmlId, paramId, value);
    }
}

