/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.core.Behaviour;
import hmi.bml.ext.bmlt.BMLTAudioFileBehaviour;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.audioengine.AudioPlayer;
import hmi.elckerlyc.audioengine.AudioUnitPlanningException;
import hmi.elckerlyc.audioengine.TimedAbstractAudioUnit;
import hmi.elckerlyc.audioengine.TimedWavAudioUnit;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlanner
extends AbstractPlanner {
    private AudioPlayer player;
    private static Logger logger = LoggerFactory.getLogger((String)AudioPlanner.class.getName());
    private static final double TIMEPEG_TOLERANCE = 0.003;

    public AudioPlanner(AudioPlayer p) {
        this.player = p;
    }

    private TimedAbstractAudioUnit createAudioUnit(BMLBlockPeg bbPeg, Behaviour b) throws BehaviourPlanningException {
        BMLTAudioFileBehaviour bAudio = (BMLTAudioFileBehaviour)b;
        TimedWavAudioUnit au = new TimedWavAudioUnit(bbPeg, bAudio.getStringParameterValue("fileName"), bAudio.id, bAudio.bmlId);
        try {
            au.setup();
        }
        catch (AudioUnitPlanningException e) {
            BehaviourPlanningException bpe = new BehaviourPlanningException(b, e.getLocalizedMessage());
            bpe.initCause(e);
            throw bpe;
        }
        logger.debug("Creating audio unit {} duration: {}", (Object)b.id, (Object)au.getPreferedDuration());
        return au;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedPlanUnit planElement) throws BehaviourPlanningException {
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        TimedAbstractAudioUnit au = planElement == null ? this.createAudioUnit(bbPeg, b) : (TimedAbstractAudioUnit)planElement;
        for (TimePegAndConstraint sac : sacs) {
            OffsetPeg p;
            if (sac.id.equals("start")) {
                if (sac.offset == 0.0) {
                    au.setStart(sac.peg);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, sac.peg));
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    au.setStart(p);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, p));
                }
            }
            if (!sac.id.equals("end")) continue;
            if (sac.offset == 0.0) {
                au.setEnd(sac.peg);
                satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, sac.peg));
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            au.setEnd(p);
            satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, p));
        }
        for (BMLFeedbackListener fb : this.getFeedbackListeners()) {
            au.addFeedbackListener(fb);
        }
        this.player.addAudioUnit(au);
        return satp;
    }

    @Override
    public TimedPlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        TimedAbstractAudioUnit au = this.createAudioUnit(bbPeg, b);
        double startTime = 0.0;
        boolean startFound = false;
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.id.equals("start") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            startTime = sac.peg.getGlobalValue() - sac.offset;
            startFound = true;
        }
        if (!startFound) {
            for (TimePegAndConstraint sac : sacs) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308 || !sac.id.equals("end") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                startTime = sac.peg.getGlobalValue() - au.getPreferedDuration() - sac.offset;
                break;
            }
        }
        TimePegAndConstraint sacNotStart = null;
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) continue;
            sacNotStart = sac;
            break;
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("end")) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) {
                    sac.peg.setGlobalValue(au.getPreferedDuration() + startTime + sac.offset);
                } else if (Math.abs(sac.peg.getGlobalValue() - (startTime + au.getPreferedDuration() + sac.offset)) > 0.003) {
                    throw new BehaviourPlanningException(b, "Stretching audio fragments is not supported yet. Should not be too hard to do, though. Behavior omitted.");
                }
            }
            if (!sac.id.equals("start") || sac.peg.getGlobalValue() != -1.7976931348623157E308) continue;
            if (sac.resolveAsStartOffset) {
                OffsetPeg p = (OffsetPeg)sac.peg;
                p.setLink(sacNotStart.peg);
                p.setOffset(startTime - sacNotStart.peg.getGlobalValue());
                continue;
            }
            sac.peg.setGlobalValue(startTime + sac.offset);
        }
        return au;
    }

    @Override
    public Set<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviours();
    }

    @Override
    public void clearAll(double time) {
        this.player.clearAll(time);
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.removeAudioUnit(behaviourId, BMLId);
    }

    @Override
    public void interruptBehaviour(String behaviourId, String BMLId, double globalTime) {
        this.player.removeAudioUnit(behaviourId, BMLId);
    }

    public AudioPlayer getAudioPlayer() {
        return this.player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void addExceptionListener(BMLExceptionListener war) {
        this.player.addExceptionListener(war);
    }

    @Override
    public void removeAllExceptionListeners() {
        this.player.removeAllExceptionListeners();
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTAudioFileBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTAudioFileBehaviour.class);
        return list;
    }

    @Override
    public void reset() {
        this.player.reset();
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        this.player.setParameterValue(behId, bmlId, paramId, value);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        this.player.setParameterValue(behId, bmlId, paramId, value);
    }
}

