/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.audioengine.AudioPlanPlayer;
import hmi.elckerlyc.audioengine.TimedAbstractAudioUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.testutil.bml.feedback.ListBMLExceptionListener;
import java.util.ArrayList;
import mockit.Mock;
import mockit.MockUp;
import org.junit.Assert;
import org.junit.Test;

public class AudioPlanPlayerAudioUnitStubTest {
    @Test
    public void testPlayAudioUnit() throws InterruptedException, TimedPlanUnitPlayException {
        new MockUp<StubAudioUnit>(){

            @Mock(invocations=1)
            protected void playUnit(double time) {
            }

            @Mock(invocations=1)
            protected void startUnit(double time) {
            }

            @Mock
            public double getPreferedDuration() {
                return 5.0;
            }
        };
        ArrayList beList = new ArrayList();
        StubAudioUnit auStub = new StubAudioUnit(BMLBlockPeg.GLOBALPEG, "dummyfile", "id1", "bml1");
        auStub.setState(TimedPlanUnitState.LURKING);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        auStub.setStart(tpStart);
        AudioPlanPlayer app = new AudioPlanPlayer();
        app.addExceptionListener((BMLExceptionListener)new ListBMLExceptionListener(beList));
        app.addAudioUnit(auStub);
        app.play(0.0);
        Thread.sleep(100L);
        Assert.assertTrue((beList.size() == 0 ? 1 : 0) != 0);
        app.shutdown();
    }

    @Test
    public void testAddAudioUnit() {
        AudioPlanPlayer app = new AudioPlanPlayer();
        StubAudioUnit auStub = new StubAudioUnit(BMLBlockPeg.GLOBALPEG, "dummyfile", "id1", "bml1");
        app.addAudioUnit(auStub);
        Assert.assertEquals((long)1L, (long)app.getBehaviours("bml1").size());
        Assert.assertTrue((boolean)app.getBehaviours("bml1").contains("id1"));
    }

    private static class StubAudioUnit
    extends TimedAbstractAudioUnit {
        public StubAudioUnit(BMLBlockPeg bbPeg, String fname, String id, String bmlId) {
            super(bbPeg, fname, id, bmlId);
        }

        @Override
        public void sendProgress(double playTime, double time) {
        }

        @Override
        public void setParameterValue(String paramater, float value) {
        }

        @Override
        protected void startUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void playUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        public double getPreferedDuration() {
            return 0.0;
        }

        @Override
        public void setParameterValue(String paramId, String value) {
        }
    }
}

