/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.audioengine.TimedAbstractAudioUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlanPlayer {
    private static Logger logger = LoggerFactory.getLogger((String)AudioPlanPlayer.class.getName());
    @GuardedBy(value="audioUnits")
    private double time;
    @GuardedBy(value="audioUnits")
    private ArrayList<TimedAbstractAudioUnit> audioUnits;
    @GuardedBy(value="audioUnits")
    private boolean doStop = false;
    private Future<?> audioRunner = null;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    @GuardedBy(value="this")
    private List<BMLExceptionListener> exceptionListeners = new ArrayList<BMLExceptionListener>();

    public synchronized void exception(BMLExceptionFeedback e) {
        for (BMLExceptionListener el : this.exceptionListeners) {
            el.exception(e);
        }
    }

    public synchronized void addExceptionListener(BMLExceptionListener es) {
        this.exceptionListeners.add(es);
    }

    public synchronized void removeAllExceptionListeners() {
        this.exceptionListeners.clear();
    }

    private void auException(TimedAbstractAudioUnit au, String message, double time) {
        String bmlId = au.getBMLId();
        String id = "w-" + au.getId();
        HashSet<String> droppedBehaviours = new HashSet<String>();
        droppedBehaviours.add(au.getId());
        HashSet modifiedConstraints = new HashSet();
        String warningText = String.valueOf(message) + "\nBehavior " + au.getBMLId() + ":" + au.getId() + " dropped.";
        this.exception(new BMLExceptionFeedback(id, bmlId, time, droppedBehaviours, modifiedConstraints, warningText, false));
    }

    public AudioPlanPlayer() {
        this.audioUnits = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedAbstractAudioUnit getAudioUnit(String id, String bmlId) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                if (!au.getId().equals(id) || !au.getBMLId().equals(bmlId)) continue;
                return au;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioUnit(TimedAbstractAudioUnit au) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.audioUnits.add(au);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAudioUnits() {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            return this.audioUnits.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAudioUnit(TimedAbstractAudioUnit au) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            au.stop();
            this.audioUnits.remove(au);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAudioUnit(String id, String bmlId) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            TimedAbstractAudioUnit au = this.getAudioUnit(id, bmlId);
            if (au != null) {
                this.removeAudioUnit(au);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(double t) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.time = t;
        }
        if (this.audioRunner == null || this.audioRunner.isDone()) {
            this.audioRunner = this.exec.submit(new AudioRunner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStop() {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.doStop = true;
        }
        if (this.audioRunner != null) {
            try {
                this.audioRunner.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException e) {
                logger.warn("ExecutionException in scheduleStop when stopping the audioRunnter thread:\n {}", (Throwable)e);
            }
        }
        arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.doStop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAudioUnits(List<TimedAbstractAudioUnit> auList) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : auList) {
                if (!au.isPlaying()) continue;
                try {
                    au.stop(0.0);
                }
                catch (TimedPlanUnitPlayException e) {
                    logger.warn("SpeechUnit won't stop: {}", (Throwable)e);
                }
            }
            this.audioUnits.removeAll(auList);
        }
    }

    public void shutdown() throws InterruptedException {
        this.exec.shutdown();
        this.exec.awaitTermination(1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.debug("AudioPP stop()");
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            logger.debug("Stopping audiounits");
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                au.stop();
            }
        }
        this.scheduleStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                au.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInvalidBehaviors() {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            HashSet<String> invalidBehaviors = new HashSet<String>();
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                if (au.hasValidTiming()) continue;
                invalidBehaviors.add(String.valueOf(au.getBMLId()) + ":" + au.getId());
            }
            return invalidBehaviors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(double absoluteTime) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            logger.debug("Stopping audiounits");
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                try {
                    au.stop(absoluteTime - au.getBMLBlockPeg().getValue());
                }
                catch (TimedPlanUnitPlayException e) {
                    logger.warn("Error stopping behavior " + au.getBMLId() + ":" + au.getId(), (Throwable)e);
                }
            }
            logger.debug("Clearing audiounits");
            this.audioUnits.clear();
        }
        logger.debug("Schedule AudioPP stop");
        this.scheduleStop();
        logger.debug("AudioPP cleared");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                if (!au.getBMLId().equals(bmlId)) continue;
                au.setState(state);
            }
        }
    }

    public synchronized double getEndTime(String behId, String bmlId) {
        TimedAbstractAudioUnit pu = this.getAudioUnit(behId, bmlId);
        if (pu == null) {
            return -1.7976931348623157E308;
        }
        return pu.getEndTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<String> getBehaviours(String bmlId) {
        HashSet<String> behaviours = new HashSet<String>();
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                if (!au.getBMLId().equals(bmlId)) continue;
                behaviours.add(au.getId());
            }
        }
        return behaviours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void interruptBehaviourBlock(String bmlId, double time) {
        ArrayList<TimedAbstractAudioUnit> removeUnits = new ArrayList<TimedAbstractAudioUnit>();
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                if (!au.getBMLId().equals(bmlId)) continue;
                try {
                    au.stop(time);
                }
                catch (TimedPlanUnitPlayException e) {
                    logger.warn("Exception when interrupting behavior " + au, (Throwable)e);
                }
                removeUnits.add(au);
            }
        }
        this.removeAudioUnits(removeUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                if (!au.getBMLId().equals(bmlId) || !au.getId().equals(behId)) continue;
                au.setParameterValue(paramId, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        ArrayList<TimedAbstractAudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (TimedAbstractAudioUnit au : this.audioUnits) {
                if (!au.getBMLId().equals(bmlId) || !au.getId().equals(behId)) continue;
                au.setParameterValue(paramId, value);
            }
        }
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ ArrayList access$1(AudioPlanPlayer audioPlanPlayer) {
        return audioPlanPlayer.audioUnits;
    }

    static /* synthetic */ boolean access$2(AudioPlanPlayer audioPlanPlayer) {
        return audioPlanPlayer.doStop;
    }

    static /* synthetic */ double access$3(AudioPlanPlayer audioPlanPlayer) {
        return audioPlanPlayer.time;
    }

    static /* synthetic */ void access$4(AudioPlanPlayer audioPlanPlayer, TimedAbstractAudioUnit timedAbstractAudioUnit, String string, double d) {
        audioPlanPlayer.auException(timedAbstractAudioUnit, string, d);
    }

    class AudioRunner
    implements Runnable {
        AudioRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            AudioPlanPlayer.access$0().debug("start audioplanplayer");
            oldTime = -1.0;
            audioUnitsCache = new ArrayList<E>();
            audioUnitsRemove = new ArrayList<TimedAbstractAudioUnit>();
            block7: while (true) {
                var7_5 = AudioPlanPlayer.access$1(AudioPlanPlayer.this);
                synchronized (var7_5) {
                    AudioPlanPlayer.access$1(AudioPlanPlayer.this).removeAll(audioUnitsRemove);
                    if (AudioPlanPlayer.access$2(AudioPlanPlayer.this)) {
                        AudioPlanPlayer.access$0().debug("break");
                        break;
                    }
                    t = AudioPlanPlayer.access$3(AudioPlanPlayer.this);
                    audioUnitsCache.clear();
                    audioUnitsCache.addAll(AudioPlanPlayer.access$1(AudioPlanPlayer.this));
                }
                if (t == oldTime) continue;
                oldTime = t;
                audioUnitsRemove.clear();
                var8_6 = audioUnitsCache.iterator();
                while (true) {
                    if (var8_6.hasNext()) ** break;
                    continue block7;
                    au = (TimedAbstractAudioUnit)var8_6.next();
                    AudioPlanPlayer.access$0().debug("checking au {}:{}", (Object)au.getId(), (Object)au.getBMLId());
                    if (!(t >= au.getStartTime())) continue;
                    if (au.getState().isLurking()) {
                        try {
                            au.start(t);
                        }
                        catch (TimedPlanUnitPlayException e) {
                            AudioPlanPlayer.access$4(AudioPlanPlayer.this, au, e.getLocalizedMessage(), t);
                            audioUnitsRemove.add(au);
                        }
                    }
                    if (!au.getState().isPlaying()) continue;
                    try {
                        au.play(t);
                    }
                    catch (TimedPlanUnitPlayException e) {
                        AudioPlanPlayer.access$4(AudioPlanPlayer.this, au, e.getLocalizedMessage(), t);
                        audioUnitsRemove.add(au);
                    }
                }
                break;
            }
            AudioPlanPlayer.access$0().debug("stop audioplanplayer");
        }
    }
}

