/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.anticipator;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.anticipator.SpaceBarTempoAnticipator;
import hmi.util.SystemClock;
import java.awt.event.KeyEvent;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class SpaceBarTempoAnticipatorTest {
    @Mocked
    KeyEvent mockKeyEvent;

    @Test
    public void test() {
        SpaceBarTempoAnticipator sbta = new SpaceBarTempoAnticipator();
        BMLBlockPeg bbPeg = new BMLBlockPeg("bml1", 0.3);
        StubSystemClock stubSystemClock = new StubSystemClock();
        TimePeg[] sp = new TimePeg[100];
        int i = 0;
        while (i < 100) {
            sp[i] = new TimePeg(bbPeg);
            sp[i].setGlobalValue(i);
            sbta.addSynchronisationPoint("s" + i, sp[i]);
            ++i;
        }
        sbta.setPhysicsClock(stubSystemClock);
        new NonStrictExpectations(){
            {
                SpaceBarTempoAnticipatorTest.this.mockKeyEvent.getKeyCode();
                this.returns(32);
                times = 10;
            }
        };
        i = 0;
        while (i < 5) {
            stubSystemClock.setTime((double)i * 2.0);
            sbta.keyPressed(this.mockKeyEvent);
            sbta.keyReleased(this.mockKeyEvent);
            ++i;
        }
        Assert.assertEquals((double)0.0, (double)sp[0].getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)sp[1].getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)sp[2].getGlobalValue(), (double)1.0E-4);
        i = 3;
        while (i < 100) {
            Assert.assertEquals((double)((i - 1) * 2), (double)sp[i].getGlobalValue(), (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void test2() {
        SpaceBarTempoAnticipator sbta = new SpaceBarTempoAnticipator();
        BMLBlockPeg bbPeg = new BMLBlockPeg("bml1", 0.3);
        StubSystemClock stubSystemClock = new StubSystemClock();
        TimePeg[] sp = new TimePeg[100];
        int i = 0;
        while (i < 100) {
            sp[i] = new TimePeg(bbPeg);
            sp[i].setGlobalValue(i);
            sbta.addSynchronisationPoint("s" + i, sp[i]);
            ++i;
        }
        sbta.setPhysicsClock(stubSystemClock);
        new NonStrictExpectations(){
            {
                SpaceBarTempoAnticipatorTest.this.mockKeyEvent.getKeyCode();
                this.returns(32);
                times = 10;
            }
        };
        i = 0;
        while (i < 5) {
            stubSystemClock.setTime((double)i * 2.0 + 0.1);
            sbta.keyPressed(this.mockKeyEvent);
            sbta.keyReleased(this.mockKeyEvent);
            ++i;
        }
        Assert.assertEquals((double)0.0, (double)sp[0].getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)sp[1].getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.1, (double)sp[2].getGlobalValue(), (double)1.0E-4);
        i = 3;
        while (i < 100) {
            Assert.assertEquals((double)((double)((i - 1) * 2) + 0.1), (double)sp[i].getGlobalValue(), (double)1.0E-4);
            ++i;
        }
    }

    @Test
    public void test3() {
        SpaceBarTempoAnticipator sbta = new SpaceBarTempoAnticipator();
        BMLBlockPeg bbPeg = new BMLBlockPeg("bml1", 0.3);
        StubSystemClock stubSystemClock = new StubSystemClock();
        TimePeg[] sp = new TimePeg[100];
        int i = 0;
        while (i < 100) {
            sp[i] = new TimePeg(bbPeg);
            sp[i].setGlobalValue(i);
            sbta.addSynchronisationPoint("s" + i, sp[i]);
            ++i;
        }
        sbta.setPhysicsClock(stubSystemClock);
        new NonStrictExpectations(){
            {
                SpaceBarTempoAnticipatorTest.this.mockKeyEvent.getKeyCode();
                this.returns(32);
                times = 10;
            }
        };
        i = 0;
        while (i < 5) {
            stubSystemClock.setTime((double)i * 0.5 + 0.1);
            sbta.keyPressed(this.mockKeyEvent);
            sbta.keyReleased(this.mockKeyEvent);
            ++i;
        }
        Assert.assertEquals((double)0.0, (double)sp[0].getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)sp[1].getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.6, (double)sp[2].getGlobalValue(), (double)1.0E-4);
        i = 3;
        while (i < 100) {
            Assert.assertEquals((double)((double)(i - 2) * 0.5 + 1.6), (double)sp[i].getGlobalValue(), (double)1.0E-4);
            ++i;
        }
    }

    private static class StubSystemClock
    extends SystemClock {
        private double time = 0.0;

        private StubSystemClock() {
        }

        public void setTime(double t) {
            this.time = t;
        }

        public double getMediaSeconds() {
            return this.time;
        }
    }
}

