/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.transitions;

import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.animationengine.transitions.TransitionTMU;
import java.util.ArrayList;
import java.util.List;

public abstract class TransitionMU
implements MotionUnit {
    protected List<VJoint> joints;
    private double prefDuration = 2.0;
    private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public KeyPosition getKeyPosition(String id) {
        return this.keyPositionManager.getKeyPosition(id);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }

    @Override
    public abstract TransitionMU copy(AnimationPlayer var1);

    public TransitionMU() {
        this.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
    }

    @Override
    public TimedMotionUnit createTMU(BMLBlockPeg bbPeg, String i, String bmlId) {
        return new TransitionTMU(bbPeg, i, bmlId, this);
    }

    @Override
    public double getPreferedDuration() {
        return this.prefDuration;
    }

    @Override
    public abstract void play(double var1);

    public abstract void setStartPose();

    public abstract void setEndPose(double var1, double var3);

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return null;
    }

    @Override
    public void setParameterValue(String name, float value) {
    }

    protected void filterJoints(String value) {
        String names = value.replace(",", " ");
        String[] jointNames = names.split("\\s");
        ArrayList<VJoint> newJoints = new ArrayList<VJoint>();
        for (VJoint vj : this.joints) {
            String[] stringArray = jointNames;
            int n = jointNames.length;
            int n2 = 0;
            while (n2 < n) {
                String jn = stringArray[n2];
                if (vj.getSid() != null && vj.getSid().equals(jn)) {
                    newJoints.add(vj);
                }
                ++n2;
            }
        }
        this.joints.clear();
        this.joints.addAll(newJoints);
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("joints")) {
            this.filterJoints(value);
        }
    }

    @Override
    public String getParameterValue(String name) {
        StringBuffer str = new StringBuffer();
        if (name.equals("joints")) {
            for (VJoint vj : this.joints) {
                if (!str.toString().equals("")) {
                    str.append(",");
                }
                str.append(vj.getSid());
            }
            return str.toString();
        }
        return null;
    }

    @Override
    public String getReplacementGroup() {
        return this.getParameterValue("replacementgroup");
    }
}

