/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.transitions;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.transitions.TransitionMU;
import hmi.math.Quat4f;
import java.util.ArrayList;
import java.util.List;

public class SlerpTransitionToPoseMU
extends TransitionMU {
    private List<VJoint> startJoints;
    private float[] endPose;
    private float[] startPose = null;
    private float[] qResult;

    public SlerpTransitionToPoseMU() {
    }

    public SlerpTransitionToPoseMU(List<VJoint> j, List<VJoint> startPoseJoints, float[] ep) {
        this.joints = j;
        this.startJoints = startPoseJoints;
        this.endPose = ep;
        this.qResult = new float[this.joints.size() * 4];
    }

    @Override
    public TransitionMU copy(AnimationPlayer player) {
        ArrayList<VJoint> startPoseJoints = new ArrayList<VJoint>();
        float[] ep = null;
        if (this.endPose != null) {
            ep = new float[this.endPose.length];
            int i = 0;
            while (i < this.endPose.length) {
                ep[i] = this.endPose[i];
                ++i;
            }
        }
        if (this.startJoints == null) {
            startPoseJoints.addAll(player.getVNext().getParts());
        } else {
            for (VJoint vj : this.startJoints) {
                VJoint vNew = player.getVNext().getPart(vj.getSid());
                startPoseJoints.add(vNew);
            }
        }
        if (this.joints != null) {
            ArrayList<VJoint> newJoints = new ArrayList<VJoint>();
            for (VJoint vj : this.joints) {
                VJoint newJ = player.getVNext().getPart(vj.getSid());
                if (newJ == null) continue;
                this.joints.add(newJ);
            }
            return new SlerpTransitionToPoseMU(newJoints, startPoseJoints, ep);
        }
        return new SlerpTransitionToPoseMU(player.getVNext().getParts(), startPoseJoints, ep);
    }

    public void setStartPose(float[] sp) {
        this.startPose = sp;
    }

    @Override
    public void setStartPose() {
        int i = 0;
        this.startPose = new float[this.joints.size() * 4];
        for (VJoint v : this.startJoints) {
            v.getRotation(this.startPose, i);
            i += 4;
        }
    }

    @Override
    public void play(double t) {
        if (this.startPose != null) {
            Quat4f.interpolateArrays((float[])this.qResult, (float[])this.startPose, (float[])this.endPose, (float)((float)t));
            int i = 0;
            for (VJoint vj : this.joints) {
                vj.setRotation(this.qResult, i);
                i += 4;
            }
        }
    }

    @Override
    public void setEndPose(double endTime, double duration) {
    }
}

