/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.transitions;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.transitions.TransitionMU;
import hmi.math.Quat4f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicsSync;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlerpPhysicalTransitionMU
extends TransitionMU {
    private float[] qStart;
    private float[] qEnd;
    private float[] q;
    private AnimationPlayer player;
    private static Logger logger = LoggerFactory.getLogger((String)SlerpPhysicalTransitionMU.class.getName());

    public SlerpPhysicalTransitionMU() {
    }

    public SlerpPhysicalTransitionMU(List<VJoint> j, AnimationPlayer pl) {
        this.joints = j;
        this.qStart = new float[4 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.q = new float[4 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.player = pl;
    }

    @Override
    public TransitionMU copy(AnimationPlayer player) {
        if (this.joints != null) {
            ArrayList<VJoint> newJoints = new ArrayList<VJoint>();
            for (VJoint vj : this.joints) {
                VJoint newJ = player.getVNext().getPart(vj.getSid());
                if (newJ == null) continue;
                this.joints.add(newJ);
            }
            return new SlerpPhysicalTransitionMU(newJoints, player);
        }
        return new SlerpPhysicalTransitionMU(player.getVNext().getParts(), player);
    }

    @Override
    public void play(double t) {
        int i = 0;
        while (i < this.joints.size()) {
            Quat4f.interpolate((float[])this.q, (int)(i * 4), (float[])this.qStart, (int)(i * 4), (float[])this.qEnd, (int)(i * 4), (float)((float)t));
            ++i;
        }
        i = 0;
        for (VJoint j : this.joints) {
            j.setRotation(this.q, i);
            i += 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartPose() {
        PhysicalHumanoid pHuman = this.player.getPHuman();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            int i = 0;
            for (VJoint j : this.joints) {
                PhysicalJoint pj = pHuman.getJoint(j.getSid());
                if (pj != null) {
                    pj.getRotation(this.qStart, i * 4);
                    logger.debug(j.getSid());
                    logger.debug("qStart = {}", (Object)Quat4f.toString((float[])this.qStart, (int)(i * 4)));
                } else {
                    Quat4f.setIdentity((float[])this.qStart, (int)(i * 4));
                }
                ++i;
            }
        }
    }

    @Override
    public void setEndPose(double endTime, double duration) {
        VJoint pred = this.player.getVPredict();
        this.player.predict(endTime);
        int i = 0;
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(this.qEnd, i);
            i += 4;
        }
    }
}

