/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.transitions;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.transitions.TransitionMU;
import hmi.math.NumMath;
import hmi.math.Quat4f;
import hmi.math.QuatCurve;
import hmi.math.Vec3f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicsSync;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HermiteSplinePhysicalTransitionMU
extends TransitionMU {
    private float[] qStart;
    private float[] qEnd;
    private float[] wStart;
    private float[] wEnd;
    private float[] q;
    private AnimationPlayer player;
    private Logger logger = LoggerFactory.getLogger((String)HermiteSplinePhysicalTransitionMU.class.getName());

    public HermiteSplinePhysicalTransitionMU() {
    }

    public HermiteSplinePhysicalTransitionMU(List<VJoint> j, AnimationPlayer pl) {
        this.joints = j;
        this.qStart = new float[4 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.q = new float[4 * j.size()];
        this.wStart = new float[3 * j.size()];
        this.wEnd = new float[3 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.wEnd = new float[3 * j.size()];
        this.player = pl;
    }

    @Override
    public TransitionMU copy(AnimationPlayer p) {
        if (this.joints != null) {
            ArrayList<VJoint> newJoints = new ArrayList<VJoint>();
            for (VJoint vj : this.joints) {
                VJoint newJ = p.getVNext().getPart(vj.getSid());
                if (newJ == null) continue;
                this.joints.add(newJ);
            }
            return new HermiteSplinePhysicalTransitionMU(newJoints, p);
        }
        return new HermiteSplinePhysicalTransitionMU(p.getVNext().getParts(), p);
    }

    @Override
    public void play(double t) {
        int i = 0;
        while (i < this.joints.size()) {
            QuatCurve.hermite((float[])this.qStart, (int)(i * 4), (float[])this.qEnd, (int)(i * 4), (float[])this.wStart, (int)(i * 3), (float[])this.wEnd, (int)(i * 3), (float)((float)t), (float[])this.q, (int)(i * 4));
            ++i;
        }
        i = 0;
        for (VJoint j : this.joints) {
            j.setRotation(this.q, i);
            i += 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartPose() {
        PhysicalHumanoid pHuman = this.player.getPHuman();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            int i = 0;
            for (VJoint j : this.joints) {
                PhysicalJoint pj = pHuman.getJoint(j.getSid());
                if (pj != null) {
                    pj.getRotation(this.qStart, i * 4);
                    pj.getAngularVelocity(this.wStart, i * 3);
                    this.logger.debug(j.getSid());
                    this.logger.debug("qStart = {}", (Object)Quat4f.toString((float[])this.qStart, (int)(i * 4)));
                    this.logger.debug("wStart = {}", (Object)Vec3f.toString((float[])this.wStart, (int)(i * 3)));
                } else {
                    this.logger.debug("Setting zero start rot/vel at:", (Object)j.getSid());
                    Quat4f.setIdentity((float[])this.qStart, (int)(i * 4));
                    Vec3f.setZero((float[])this.wStart, (int)(i * 3));
                }
                ++i;
            }
        }
    }

    @Override
    public void setEndPose(double endTime, double duration) {
        int i = 0;
        while (i < this.joints.size()) {
            Vec3f.scale((float)((float)duration), (float[])this.wStart, (int)(i * 3));
            ++i;
        }
        int nrOfJoints = this.joints.size();
        float[] qPrev = new float[nrOfJoints * 4];
        float[] qNext = new float[nrOfJoints * 4];
        float[] qrate = new float[nrOfJoints * 4];
        int i2 = 0;
        VJoint pred = this.player.getVPredict();
        this.player.predict(endTime);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(qPrev, i2);
            i2 += 4;
        }
        i2 = 0;
        this.player.predict(endTime + (double)0.001f);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(this.qEnd, i2);
            i2 += 4;
        }
        i2 = 0;
        this.player.predict(endTime + (double)0.002f);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(qNext, i2);
            i2 += 4;
        }
        i2 = 0;
        while (i2 < nrOfJoints * 4) {
            qrate[i2] = NumMath.diff((float)qPrev[i2], (float)qNext[i2], (float)0.001f);
            ++i2;
        }
        i2 = 0;
        while (i2 < nrOfJoints) {
            Quat4f.setAngularVelocityFromQuat4f((float[])this.wEnd, (int)(i2 * 3), (float[])this.qEnd, (int)(i2 * 4), (float[])qrate, (int)(i2 * 4));
            Vec3f.scale((float)((float)duration), (float[])this.wEnd);
            this.logger.debug("qPrev = {}", (Object)Quat4f.toString((float[])qPrev, (int)(i2 * 4)));
            this.logger.debug("qEnd = {}", (Object)Quat4f.toString((float[])this.qEnd, (int)(i2 * 4)));
            this.logger.debug("qNext = {}", (Object)Quat4f.toString((float[])qNext, (int)(i2 * 4)));
            this.logger.debug("wEnd = {}", (Object)Vec3f.toString((float[])this.wEnd, (int)(i2 * 3)));
            ++i2;
        }
    }
}

