/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.VJoint;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Vector;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Rotation
extends XMLStructureAdapter {
    private Node[] node = new Node[3];
    private String[] rotFormula = new String[3];
    private String target = "";
    private VJoint joint;
    private XJep parser;
    private boolean local = true;

    public void mirror() {
        if (this.target.startsWith("l_")) {
            this.target = this.target.replace("l_", "r_");
        } else if (this.target.startsWith("r_")) {
            this.target = this.target.replace("r_", "l_");
        }
        try {
            this.setRotation(1, "-(" + this.rotFormula[1] + ")");
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            this.setRotation(2, "-(" + this.rotFormula[2] + ")");
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Rotation(XJep p) {
        this.parser = p;
        this.target = null;
    }

    public Rotation(XJep p, String t) {
        this.parser = p;
        this.target = t;
    }

    public void set(Rotation eff) {
        int i = 0;
        while (i < 3) {
            try {
                this.setRotation(i, eff.rotFormula[i]);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
            ++i;
        }
        this.target = eff.target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public String getRotationFormula(int i) {
        return this.rotFormula[i];
    }

    public void setRotation(int i, String rotation) throws ParseException {
        this.rotFormula[i] = rotation;
        this.node[i] = this.parser.preprocess(this.parser.parse(rotation));
    }

    public boolean evaluate(float[] goal) {
        int i = 0;
        while (i < 3) {
            if (this.node[i] == null) {
                return false;
            }
            try {
                goal[i] = ((Double)this.parser.evaluate(this.node[i])).floatValue();
            }
            catch (ParseException e) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public float evaluateSingleIndex(int i) {
        if (this.node[i] != null) {
            try {
                return ((Double)this.parser.evaluate(this.node[i])).floatValue();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return 0.0f;
    }

    public Vector findParameters(Vector v) {
        int i = 0;
        while (i < 3) {
            if (this.node[i] != null) {
                v = this.parser.getVarsInEquation(this.node[i], v);
            }
            ++i;
        }
        return v;
    }

    public void setTarget(VJoint h) {
        this.joint = h.getPart(this.target);
    }

    public void setJoint(VJoint j) {
        this.joint = j;
        if (j != null) {
            this.target = j.getSid();
        }
    }

    public VJoint getJoint() {
        return this.joint;
    }

    public Rotation deepCopy() {
        Rotation copy = new Rotation(this.parser, this.target);
        try {
            copy.setRotation(0, this.getRotationFormula(0));
            copy.setRotation(1, this.getRotationFormula(1));
            copy.setRotation(2, this.getRotationFormula(2));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        copy.setJoint(this.joint);
        copy.target = this.target;
        return copy;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("target")) {
            this.target = attrValue;
        } else if (attrName.equals("local")) {
            this.local = Boolean.parseBoolean(attrValue);
        } else if (attrName.equals("rotation")) {
            String str = attrValue;
            this.rotFormula = str.split(";");
            try {
                this.setRotation(0, this.rotFormula[0]);
                this.setRotation(1, this.rotFormula[1]);
                this.setRotation(2, this.rotFormula[2]);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return false;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        if (this.rotFormula[0] != null) {
            String str = String.valueOf(this.rotFormula[0]) + ";" + this.rotFormula[1] + ";" + this.rotFormula[2];
            Rotation.appendAttribute((StringBuilder)buf, (String)"rotation", (String)str);
        }
        Rotation.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        return buf;
    }

    public String getXMLTag() {
        return "Rotation";
    }
}

