/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.procanimation.IKBody;
import hmi.elckerlyc.animationengine.procanimation.Parameter;
import hmi.elckerlyc.animationengine.procanimation.ProcAnimationMU;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.testutil.animation.HanimBody;
import hmi.testutil.math.Quat4fTestUtil;
import hmi.testutil.math.Vec3fTestUtil;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;

public class ProcAnimationTest {
    private IKBody ikBody;
    private VJoint human;
    private ProcAnimationMU procAnimation;
    private static final double SKI_STARTTIME = 1.0;
    private static final double SKI_ENDTIME = 2.0;
    private static final float[] HUMANOIDROOT_POS = Vec3f.getVec3f((float)0.0f, (float)1.0f, (float)1.0f);
    private static final float[] HUMANOIDROOT_ROT = Quat4f.getQuat4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    private static final float[] L_SHOULDER_ROT = Quat4f.getQuat4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    private static final float[] R_SHOULDER_ROT = Quat4f.getQuat4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);

    @Before
    public void loadDaeHuman() {
        this.human = HanimBody.getLOA1HanimBody();
        this.ikBody = new IKBody(this.human);
        String puString = "<ProcAnimation duration=\"3\" prefDuration=\"3\" minDuration=\"3\" maxDuration=\"3\"><SkeletonInterpolator rotationEncoding=\"quaternions\" parts=\"HumanoidRoot l_shoulder r_shoulder\" encoding=\"T1R\">1.0 " + HUMANOIDROOT_POS[0] + " " + HUMANOIDROOT_POS[1] + " " + HUMANOIDROOT_POS[2] + " " + HUMANOIDROOT_ROT[0] + " " + HUMANOIDROOT_ROT[1] + " " + HUMANOIDROOT_ROT[2] + " " + HUMANOIDROOT_ROT[3] + " " + L_SHOULDER_ROT[0] + " " + L_SHOULDER_ROT[1] + " " + L_SHOULDER_ROT[2] + " " + L_SHOULDER_ROT[3] + " " + R_SHOULDER_ROT[0] + " " + R_SHOULDER_ROT[1] + " " + R_SHOULDER_ROT[2] + " " + R_SHOULDER_ROT[3] + "\n" + 2.0 + " " + HUMANOIDROOT_POS[0] + " " + HUMANOIDROOT_POS[1] + " " + HUMANOIDROOT_POS[2] + " " + HUMANOIDROOT_ROT[0] + " " + HUMANOIDROOT_ROT[1] + " " + HUMANOIDROOT_ROT[2] + " " + HUMANOIDROOT_ROT[3] + " " + L_SHOULDER_ROT[0] + " " + L_SHOULDER_ROT[1] + " " + L_SHOULDER_ROT[2] + " " + L_SHOULDER_ROT[3] + " " + R_SHOULDER_ROT[0] + " " + R_SHOULDER_ROT[1] + " " + R_SHOULDER_ROT[2] + " " + R_SHOULDER_ROT[3] + " " + "</SkeletonInterpolator>" + "</ProcAnimation>";
        this.procAnimation = new ProcAnimationMU();
        this.procAnimation.readXML(puString);
        this.procAnimation.setup(new ArrayList<Parameter>(), this.ikBody);
    }

    @Test
    public void testJoints() {
        this.procAnimation.setParameterValue("joints", "r_shoulder r_elbow");
        this.human.getPart("HumanoidRoot").setTranslation(0.0f, 0.0f, 0.0f);
        this.procAnimation.play(0.0);
        float[] t = Vec3f.getVec3f();
        this.human.getPart("HumanoidRoot").getTranslation(t);
        Vec3fTestUtil.assertVec3fEquals((float)0.0f, (float)0.0f, (float)0.0f, (float[])t, (float)1.0E-4f);
    }

    @Test
    public void testJointsAfterCopy() throws MUPlayException {
        this.procAnimation.setParameterValue("joints", "r_shoulder r_elbow");
        VJoint humanCopy = HanimBody.getLOA1HanimBody();
        humanCopy.getPart("HumanoidRoot").setTranslation(0.0f, 0.0f, 0.0f);
        MotionUnit mu = this.procAnimation.copy(humanCopy);
        mu.play(0.0);
        float[] t = Vec3f.getVec3f();
        humanCopy.getPart("HumanoidRoot").getTranslation(t);
        Vec3fTestUtil.assertVec3fEquals((float)0.0f, (float)0.0f, (float)0.0f, (float[])t, (float)1.0E-4f);
    }

    @Test
    public void testMirror() {
        this.procAnimation.setParameterValue("mirror", "true");
        this.procAnimation.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("HumanoidRoot").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)HUMANOIDROOT_ROT[0], (float)HUMANOIDROOT_ROT[1], (float)(-HUMANOIDROOT_ROT[2]), (float)(-HUMANOIDROOT_ROT[3]), (float[])q, (float)0.001f);
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)R_SHOULDER_ROT[0], (float)R_SHOULDER_ROT[1], (float)(-R_SHOULDER_ROT[2]), (float)(-R_SHOULDER_ROT[3]), (float[])q, (float)0.001f);
        this.human.getPart("r_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)L_SHOULDER_ROT[0], (float)L_SHOULDER_ROT[1], (float)(-L_SHOULDER_ROT[2]), (float)(-L_SHOULDER_ROT[3]), (float[])q, (float)0.001f);
    }

    @Test
    public void testMirrorThenJoints() {
        this.procAnimation.setParameterValue("mirror", "true");
        this.procAnimation.setParameterValue("joints", "l_shoulder");
        this.procAnimation.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)R_SHOULDER_ROT[0], (float)R_SHOULDER_ROT[1], (float)(-R_SHOULDER_ROT[2]), (float)(-R_SHOULDER_ROT[3]), (float[])q, (float)0.001f);
    }

    @Test
    public void testJointsThenMirror() {
        this.procAnimation.setParameterValue("joints", "l_shoulder");
        this.procAnimation.setParameterValue("mirror", "true");
        this.procAnimation.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)R_SHOULDER_ROT[0], (float)R_SHOULDER_ROT[1], (float)(-R_SHOULDER_ROT[2]), (float)(-R_SHOULDER_ROT[3]), (float[])q, (float)0.001f);
    }

    @Test
    public void testSkeletonInterpolator() {
        this.procAnimation.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("HumanoidRoot").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])HUMANOIDROOT_ROT, (float[])q, (float)0.001f);
        this.human.getPart("r_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])R_SHOULDER_ROT, (float[])q, (float)0.001f);
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])L_SHOULDER_ROT, (float[])q, (float)0.001f);
    }

    @Test
    public void testSkeletonInterpolatorSet() {
        ProcAnimationMU puCopy = new ProcAnimationMU();
        puCopy.setup(new ArrayList<Parameter>(), this.ikBody);
        puCopy.set(this.procAnimation);
        puCopy.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("HumanoidRoot").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])HUMANOIDROOT_ROT, (float[])q, (float)0.001f);
        this.human.getPart("r_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])R_SHOULDER_ROT, (float[])q, (float)0.001f);
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])L_SHOULDER_ROT, (float[])q, (float)0.001f);
    }

    @Test
    public void testCopy() throws MUPlayException {
        VJoint humanCopy = HanimBody.getLOA1HanimBody();
        MotionUnit puCopy = this.procAnimation.copy(humanCopy);
        puCopy.play(0.0);
        float[] q = Quat4f.getQuat4f();
        humanCopy.getPart("HumanoidRoot").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])HUMANOIDROOT_ROT, (float[])q, (float)0.001f);
        humanCopy.getPart("r_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])R_SHOULDER_ROT, (float[])q, (float)0.001f);
        humanCopy.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])L_SHOULDER_ROT, (float[])q, (float)0.001f);
    }
}

