/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.procanimation.Keyframes;
import hmi.math.Quat4f;
import hmi.testutil.animation.HanimBody;
import hmi.testutil.math.Quat4fTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsmp.djep.xjep.XJep;

public class KeyframesTest {
    private VJoint human;
    private float[] goal = new float[4];
    private float[] q = new float[4];
    private float[] q1 = new float[4];
    private float[] q2 = new float[4];
    private VJoint rWristJoint;
    private VJoint animationRoot;
    private Keyframes kfs;

    @Before
    public void loadDaeHuman() {
        this.human = HanimBody.getLOA1HanimBody();
        this.animationRoot = new VJoint();
        this.animationRoot.addChild(this.human);
        this.rWristJoint = this.human.getPart("r_wrist");
        this.kfs = new Keyframes(new XJep());
    }

    @Test
    public void testEvaluate1Rotation() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"true\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        Assert.assertEquals((Object)this.kfs.getTarget(), (Object)"r_wrist");
        Assert.assertEquals((Object)this.kfs.getEncoding(), (Object)"quaternion");
        Quat4f.set((float[])this.q, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        this.kfs.evaluate(0.0, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
        this.kfs.evaluate(0.8f, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
        this.kfs.evaluate(1.0, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
    }

    @Test
    public void testEvaluate2Rotations() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"true\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"0.08383378\" local=\"false\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        Assert.assertTrue((boolean)this.kfs.getTarget().equals("r_wrist"));
        Assert.assertTrue((boolean)this.kfs.getEncoding().equals("quaternion"));
        Quat4f.set((float[])this.q, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        this.kfs.evaluate(0.0, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
        this.kfs.evaluate(0.8f, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
        this.kfs.evaluate(1.0, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
    }

    @Test
    public void testEvaluate2WorldRotations() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"false\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"1.0\" local=\"false\" value=\"1.0;0.0;0.0;0.0\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        Assert.assertTrue((boolean)this.kfs.getTarget().equals("r_wrist"));
        Assert.assertTrue((boolean)this.kfs.getEncoding().equals("quaternion"));
        Quat4f.set((float[])this.q, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        this.kfs.evaluate(0.0, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
        this.kfs.evaluate(1.0, this.goal, this.human);
        Quat4f.set((float[])this.q, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
        Quat4f.set((float[])this.q1, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        Quat4f.set((float[])this.q2, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Quat4f.interpolate((float[])this.q, (float[])this.q1, (float[])this.q2, (float)0.7f);
        this.kfs.evaluate(0.7, this.goal, this.human);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.goal, (float[])this.q, (float)1.0E-6f));
        this.animationRoot.calculateMatrices();
        this.kfs.evaluate(0.7, this.goal, this.human);
        this.rWristJoint.setRotation(this.goal);
        this.animationRoot.calculateMatrices();
        this.rWristJoint.getPathRotation(this.human, this.q1);
        System.out.println(String.valueOf(Quat4f.toString((float[])this.q1)) + Quat4f.toString((float[])this.q));
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.q1, (float[])this.q, (float)1.0E-6f));
    }

    @Test
    public void testNonLocalRotation() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"false\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"1.0\" local=\"false\" value=\"1.0;0.0;0.0;0.0\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        this.human.getPart("r_shoulder").setRollPitchYawDegrees(10.0f, 20.0f, 30.0f);
        Quat4f.set((float[])this.q1, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        Quat4f.set((float[])this.q2, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.animationRoot.calculateMatrices();
        this.kfs.evaluate(0.0, this.goal, this.human);
        this.rWristJoint.setRotation(this.goal);
        this.animationRoot.calculateMatrices();
        this.rWristJoint.getPathRotation(this.human, this.q);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.q1, (float[])this.q, (float)1.0E-6f));
    }

    @Test
    public void testNonLocalRotation2() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"false\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"1.0\" local=\"false\" value=\"1.0;0.0;0.0;0.0\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        this.human.getPart("r_shoulder").setRollPitchYawDegrees(10.0f, 20.0f, 30.0f);
        Quat4f.set((float[])this.q1, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        Quat4f.set((float[])this.q2, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.animationRoot.calculateMatrices();
        this.kfs.evaluate(0.7, this.goal, this.human);
        this.rWristJoint.setRotation(this.goal);
        this.animationRoot.calculateMatrices();
        Quat4f.interpolate((float[])this.q, (float[])this.q1, (float[])this.q2, (float)0.7f);
        this.rWristJoint.getPathRotation(this.human, this.q1);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])this.q1, (float[])this.q, (float)0.001f);
    }

    @Test
    public void testWackOrdering() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"1.0\" local=\"true\" value=\"1.0;0.0;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"true\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"0.5\" local=\"true\" value=\"-0.7071068;0.0;0.0;0.7071068\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        Assert.assertEquals((Object)this.kfs.getTarget(), (Object)"r_wrist");
        Assert.assertEquals((Object)this.kfs.getEncoding(), (Object)"quaternion");
        this.kfs.evaluate(0.25, this.goal, this.human);
        Quat4f.set((float[])this.q1, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        Quat4f.set((float[])this.q2, (float)-0.7071068f, (float)0.0f, (float)0.0f, (float)0.7071068f);
        Quat4f.interpolate((float[])this.q, (float[])this.q1, (float[])this.q2, (float)0.5f);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.q, (float[])this.goal, (float)1.0E-6f));
        this.kfs.evaluate(0.75, this.goal, this.human);
        Quat4f.set((float[])this.q1, (float)-0.7071068f, (float)0.0f, (float)0.0f, (float)0.7071068f);
        Quat4f.set((float[])this.q2, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Quat4f.interpolate((float[])this.q, (float[])this.q1, (float[])this.q2, (float)0.5f);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals((float[])this.q, (float[])this.goal, (float)1.0E-6f));
    }

    @Test
    public void testStartFrame() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"true\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"0.5\" local=\"true\" value=\"-0.7071068;0.0;0.0;0.7071068\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"1.0\" local=\"true\" value=\"1.0;0.0;0.0;0.0\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        this.kfs.evaluate(0.0, this.goal, this.human);
        Quat4f.set((float[])this.q, (float)0.7071068f, (float)-0.7071068f, (float)0.0f, (float)0.0f);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])this.q, (float[])this.goal, (float)1.0E-6f);
    }

    @Test
    public void testEndFrame() {
        String str = "<Keyframes target=\"r_wrist\" encoding=\"quaternion\">";
        str = String.valueOf(str) + "<Keyframe time=\"0.0\" local=\"true\" value=\"0.7071068;-0.7071068;0.0;0.0\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"0.5\" local=\"true\" value=\"-0.7071068;0.0;0.0;0.7071068\"/>";
        str = String.valueOf(str) + "<Keyframe time=\"1.0\" local=\"true\" value=\"1.0;0.0;0.0;0.0\"/>";
        str = String.valueOf(str) + "</Keyframes>";
        this.kfs.readXML(str);
        this.kfs.setJoint(this.rWristJoint);
        this.kfs.evaluate(1.0, this.goal, this.human);
        Quat4f.set((float[])this.q, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])this.q, (float[])this.goal, (float)1.0E-6f);
    }
}

