/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.procanimation.Keyframe;
import hmi.math.Quat4f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.lsmp.djep.xjep.XJep;

public class Keyframes
extends XMLStructureAdapter {
    private String target = "";
    private String encoding = "";
    private ArrayList<Keyframe> frames = new ArrayList();
    private VJoint joint;
    private XJep parser;

    public void setTarget(VJoint h) {
        this.joint = h.getPart(this.target);
        for (Keyframe f : this.frames) {
            f.setJoint(this.joint);
        }
    }

    public void mirror() {
        for (Keyframe f : this.frames) {
            f.mirror();
        }
        if (this.target.startsWith("l_")) {
            this.target = this.target.replace("l_", "r_");
        } else if (this.target.startsWith("r_")) {
            this.target = this.target.replace("r_", "l_");
        }
    }

    public void clear() {
        this.frames.clear();
    }

    public void setJoint(VJoint j) {
        this.joint = j;
        for (Keyframe f : this.frames) {
            f.setJoint(this.joint);
            this.target = this.joint.getSid();
        }
    }

    public VJoint getJoint() {
        return this.joint;
    }

    public Keyframes(XJep p) {
        this.parser = p;
        this.target = null;
    }

    public Keyframes(XJep p, String t) {
        this.parser = p;
        this.target = t;
    }

    public void set(Keyframes kfs) {
        this.joint = kfs.joint;
        this.target = kfs.target;
        this.frames.clear();
        for (Keyframe kf : kfs.frames) {
            Keyframe k = new Keyframe(kf);
            this.frames.add(k);
        }
    }

    public Keyframes deepCopy() {
        Keyframes copy = new Keyframes(this.parser, this.target);
        copy.set(this);
        return copy;
    }

    public Vector findParameters(Vector v) {
        for (Keyframe f : this.frames) {
            f.findParameters(v);
        }
        return v;
    }

    public boolean evaluate(double t, float[] goal, VJoint human) {
        Keyframe start = null;
        Keyframe end = null;
        float[] qNext = new float[4];
        float[] qPrev = new float[4];
        for (Keyframe f : this.frames) {
            if ((double)f.getTime() <= t) {
                start = f;
                continue;
            }
            end = f;
            break;
        }
        if (end == null && start == null) {
            return false;
        }
        if (start == null) {
            end.evaluate(goal, human);
            return true;
        }
        if (end == null) {
            start.evaluate(goal, human);
            return true;
        }
        float endT = end.getTime();
        end.evaluate(qNext, human);
        start.evaluate(qPrev, human);
        float startT = start.getTime();
        Quat4f.interpolate((float[])goal, (float[])qPrev, (float[])qNext, (float)((float)((t - (double)startT) / (double)(endT - startT))));
        return true;
    }

    public String getTarget() {
        return this.target;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        for (Keyframe kf : this.frames) {
            kf.appendXML(buf, fmt);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        Keyframes.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        Keyframes.appendAttribute((StringBuilder)buf, (String)"encoding", (String)this.encoding);
        return buf;
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("target")) {
            this.target = attrValue;
        } else if (attrName.equals("encoding")) {
            this.encoding = attrValue;
        }
        return false;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (!tokenizer.atETag()) {
            if (!tokenizer.atSTag("Keyframe")) continue;
            Keyframe kf = new Keyframe(this.parser, this.encoding);
            kf.readXML(tokenizer);
            this.frames.add(kf);
        }
        Collections.sort(this.frames);
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public String getXMLTag() {
        return "Keyframes";
    }

    public String getEncoding() {
        return this.encoding;
    }
}

