/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.VJoint;
import hmi.math.Quat4f;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Vector;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Keyframe
extends XMLStructureAdapter
implements Comparable<Keyframe> {
    private XJep parser;
    private float time = 0.0f;
    private boolean local = true;
    private String[] rotFormula;
    private Node[] node = new Node[4];
    private float[] q = new float[4];
    private float[] euler = new float[3];
    private float[] qw = new float[4];
    private float[] qp = new float[4];
    private float[] aa = new float[4];
    private VJoint joint;
    private String encoding;

    public Keyframe(XJep p, String enc) {
        this.parser = p;
        this.rotFormula = new String[4];
        this.q = new float[4];
        this.euler = new float[3];
        this.qw = new float[4];
        this.qp = new float[4];
        this.encoding = enc;
    }

    public Keyframe(Keyframe kf) {
        this.local = kf.local;
        this.joint = kf.joint;
        this.parser = kf.parser;
        this.time = kf.time;
        this.encoding = kf.encoding;
        this.rotFormula = new String[4];
        this.q = new float[4];
        this.euler = new float[3];
        this.qw = new float[4];
        this.qp = new float[4];
        int rots = 4;
        if (this.encoding.equals("euler")) {
            rots = 3;
        }
        int i = 0;
        while (i < rots) {
            try {
                this.setRotation(i, kf.rotFormula[i]);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
            ++i;
        }
    }

    public void setJoint(VJoint j) {
        this.joint = j;
    }

    public void mirror() {
        if (this.encoding.equals("quaternion")) {
            this.rotFormula[2] = "-(" + this.rotFormula[2] + ")";
            this.rotFormula[3] = "-(" + this.rotFormula[3] + ")";
        } else if (this.encoding.equals("axisangles")) {
            this.rotFormula[1] = "-(" + this.rotFormula[1] + ")";
            this.rotFormula[2] = "-(" + this.rotFormula[2] + ")";
        } else if (this.encoding.equals("euler")) {
            this.rotFormula[1] = "-(" + this.rotFormula[1] + ")";
            this.rotFormula[2] = "-(" + this.rotFormula[2] + ")";
        }
    }

    public String toString() {
        String str = this.time + "  " + this.rotFormula[0] + ";" + this.rotFormula[1] + ";" + this.rotFormula[2];
        if (this.encoding.equals("quaternion") || this.encoding.equals("axisangles")) {
            str = String.valueOf(str) + ";" + this.rotFormula[3];
        }
        return str;
    }

    public void setRotation(int i, String rotation) throws ParseException {
        this.rotFormula[i] = rotation;
        this.node[i] = this.parser.preprocess(this.parser.parse(rotation));
    }

    public Vector findParameters(Vector v) {
        int i = 0;
        while (i < 3) {
            if (this.node[i] != null) {
                v = this.parser.getVarsInEquation(this.node[i], v);
            }
            ++i;
        }
        return v;
    }

    public boolean evaluate(float[] goal, VJoint human) {
        int i;
        if (this.encoding.equals("euler")) {
            i = 0;
            while (i < 3) {
                if (this.node[i] == null) {
                    return false;
                }
                try {
                    this.euler[i] = ((Double)this.parser.evaluate(this.node[i])).floatValue();
                }
                catch (ParseException e) {
                    return false;
                }
                ++i;
            }
            Quat4f.setFromRollPitchYaw((float[])this.q, (float)this.euler[2], (float)this.euler[0], (float)this.euler[1]);
        } else if (this.encoding.equals("quaternion")) {
            i = 0;
            while (i < 4) {
                if (this.node[i] == null) {
                    return false;
                }
                try {
                    this.q[i] = ((Double)this.parser.evaluate(this.node[i])).floatValue();
                }
                catch (ParseException e) {
                    return false;
                }
                ++i;
            }
        } else if (this.encoding.equals("axisangles")) {
            i = 0;
            while (i < 4) {
                if (this.node[i] == null) {
                    return false;
                }
                try {
                    this.aa[i] = ((Double)this.parser.evaluate(this.node[i])).floatValue();
                }
                catch (ParseException e) {
                    return false;
                }
                ++i;
            }
            Quat4f.setFromAxisAngle4f((float[])this.q, (float[])this.aa);
        }
        if (!this.local) {
            Quat4f.set((float[])this.qw, (float[])this.q);
            VJoint parent = this.joint.getParent();
            parent.getPathRotation(human, this.qp);
            Quat4f.inverse((float[])this.qp);
            Quat4f.mul((float[])this.q, (float[])this.qp, (float[])this.qw);
        }
        Quat4f.set((float[])goal, (float[])this.q);
        return true;
    }

    @Override
    public int compareTo(Keyframe o) {
        if (this.time < o.time) {
            return -1;
        }
        if (this.time > o.time) {
            return 1;
        }
        return 0;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        Keyframe.appendAttribute((StringBuilder)buf, (String)"time", (float)this.time);
        Keyframe.appendAttribute((StringBuilder)buf, (String)"local", (boolean)this.local);
        if (this.encoding.equals("euler")) {
            Keyframe.appendAttribute((StringBuilder)buf, (String)"value", (String)(String.valueOf(this.rotFormula[0]) + ";" + this.rotFormula[1] + ";" + this.rotFormula[2]));
        } else {
            Keyframe.appendAttribute((StringBuilder)buf, (String)"value", (String)(String.valueOf(this.rotFormula[0]) + ";" + this.rotFormula[1] + ";" + this.rotFormula[2] + ";" + this.rotFormula[3]));
        }
        return buf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("time")) {
            this.time = Float.parseFloat(attrValue);
            return false;
        } else if (attrName.equals("value")) {
            String str = attrValue;
            String[] rot = str.split(";");
            try {
                this.setRotation(0, rot[0]);
                this.setRotation(1, rot[1]);
                this.setRotation(2, rot[2]);
                if (rot.length <= 3) return false;
                this.setRotation(3, rot[3]);
                return false;
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            if (!attrName.equals("local")) return false;
            this.local = Boolean.parseBoolean(attrValue);
        }
        return false;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public String getXMLTag() {
        return "Keyframe";
    }

    public float getTime() {
        return this.time;
    }
}

