/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.pointing;

import hmi.animation.AnalyticalIKSolver;
import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.animationengine.pointing.PointingTMU;
import hmi.elckerlyc.util.timemanipulator.SigmoidManipulator;
import hmi.elckerlyc.util.timemanipulator.TimeManipulator;
import hmi.elckerlyc.world.WorldObject;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import java.util.List;

public class PointingMU
implements MotionUnit {
    protected float[] qShoulder;
    protected float[] qElbow;
    protected float[] qShoulderStart;
    protected float[] qElbowStart;
    protected float[] qTemp;
    protected float[] vecTemp;
    protected float[] vecTemp2;
    protected KeyPosition ready;
    protected KeyPosition relax;
    protected AnimationPlayer player;
    protected WorldObjectManager woManager;
    protected String target;
    protected TimeManipulator tmp;
    protected VJoint vjShoulder;
    protected VJoint vjElbow;
    protected VJoint vjWrist;
    protected VJoint vjFingerTip;
    protected String shoulderId = "r_shoulder";
    protected String elbowId = "r_elbow";
    protected String wristId = "r_wrist";
    protected String fingerTipId = "r_index3";
    protected AnalyticalIKSolver solver;
    protected String hand = "RIGHT";
    protected WorldObject woTarget;
    protected double preparationDuration;
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public KeyPosition getKeyPosition(String id) {
        return this.keyPositionManager.getKeyPosition(id);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }

    public PointingMU() {
        this.qShoulder = new float[4];
        this.qElbow = new float[4];
        this.qShoulderStart = new float[4];
        this.qElbowStart = new float[4];
        this.qTemp = new float[4];
        this.vecTemp = new float[3];
        this.vecTemp2 = new float[3];
        this.ready = new KeyPosition("ready", 0.25, 1.0);
        this.relax = new KeyPosition("relax", 0.75, 1.0);
        this.addKeyPosition(this.ready);
        this.addKeyPosition(this.relax);
        this.target = "";
        this.tmp = new SigmoidManipulator(5.0, 1.0);
    }

    public PointingMU(VJoint shoulder, VJoint elbow, VJoint wrist, VJoint fingerTip) {
        this();
        this.vjShoulder = shoulder;
        this.vjElbow = elbow;
        this.vjWrist = wrist;
        this.vjFingerTip = fingerTip;
        if (shoulder != null) {
            this.shoulderId = shoulder.getSid();
        }
        if (elbow != null) {
            this.elbowId = elbow.getSid();
        }
        if (wrist != null) {
            this.wristId = wrist.getSid();
        }
        if (fingerTip != null) {
            this.fingerTipId = fingerTip.getSid();
        }
        this.setupSolver();
    }

    private void setupSolver() {
        float[] Tv = new float[3];
        float[] Sv = new float[3];
        this.vjElbow.getPathTranslation(this.vjShoulder, Tv);
        this.vjWrist.getPathTranslation(this.vjElbow, Sv);
        this.solver = new AnalyticalIKSolver(Sv, Tv, AnalyticalIKSolver.LimbPosition.ARM, (Vec3f.length((float[])Sv) + Vec3f.length((float[])Tv)) * 0.999f);
    }

    @Override
    public PointingMU copy(AnimationPlayer p) {
        PointingMU pmu = new PointingMU();
        pmu.shoulderId = this.shoulderId;
        pmu.elbowId = this.elbowId;
        pmu.vjShoulder = p.getVNext().getPart(this.shoulderId);
        pmu.vjShoulder = p.getVNext().getPart(this.elbowId);
        pmu.vjWrist = p.getVNext().getPart(this.wristId);
        pmu.player = p;
        pmu.woManager = p.getWoManager();
        pmu.target = this.target;
        return pmu;
    }

    public void setTarget(String target) throws MUPlayException {
        if (this.woManager == null) {
            throw new MUPlayException("Pointing target not found, no WorldObjectManager set up.", this);
        }
        this.woTarget = this.woManager.getWorldObject(target);
        if (this.woTarget == null) {
            throw new MUPlayException("Pointing target not found", this);
        }
        this.vjFingerTip.getPathTranslation(null, this.vecTemp2);
        this.vjWrist.getPathTranslation(null, this.vecTemp);
        Vec3f.sub((float[])this.vecTemp2, (float[])this.vecTemp);
        this.woTarget.getTranslation(this.vecTemp, null);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.vjShoulder, (float[])this.vecTemp, (float[])this.vecTemp2);
        this.setEndRotation(this.vecTemp2);
    }

    public void setStartPose(double prep) throws MUPlayException {
        this.preparationDuration = prep;
        this.player.getVCurr().getPart(this.shoulderId).getRotation(this.qShoulderStart);
        this.player.getVCurr().getPart(this.elbowId).getRotation(this.qElbowStart);
        this.setTarget(this.target);
    }

    public void setEndRotation(float[] vecPos) {
        this.solver.solve(vecPos, this.qShoulder, this.qElbow);
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }

    public void setHand(String hand) {
        if (hand.equals("LEFT")) {
            this.shoulderId = "l_shoulder";
            this.elbowId = "l_elbow";
            this.wristId = "l_wrist";
            this.fingerTipId = "l_index3";
        } else if (hand.equals("RIGHT")) {
            this.shoulderId = "r_shoulder";
            this.elbowId = "r_elbow";
            this.wristId = "r_wrist";
            this.fingerTipId = "r_index3";
        } else if (hand.equals("UNSPECIFIED")) {
            this.shoulderId = "r_shoulder";
            this.elbowId = "r_elbow";
            this.wristId = "r_index3";
            this.fingerTipId = "r_index3";
        } else {
            throw new RuntimeException("Invalid hand spec " + hand);
        }
        this.vjShoulder = this.player.getVNext().getPart(this.shoulderId);
        this.vjElbow = this.player.getVNext().getPart(this.elbowId);
        this.vjWrist = this.player.getVNext().getPart(this.wristId);
        this.vjFingerTip = this.player.getVNext().getPart(this.fingerTipId);
        this.setupSolver();
    }

    @Override
    public void play(double t) {
        if (t < 0.25) {
            float tManip = (float)this.tmp.manip(t / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qShoulderStart, (float[])this.qShoulder, (float)tManip);
            this.vjShoulder.setRotation(this.qTemp);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qElbowStart, (float[])this.qElbow, (float)tManip);
            this.vjElbow.setRotation(this.qTemp);
        } else if (t > 0.75) {
            float tManip = (float)this.tmp.manip((t - 0.75) / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qShoulder, (float[])Quat4f.getIdentity(), (float)tManip);
            this.vjShoulder.setRotation(this.qTemp);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qElbow, (float[])Quat4f.getIdentity(), (float)tManip);
            this.vjElbow.setRotation(this.qTemp);
        } else {
            this.vjShoulder.setRotation(this.qShoulder);
            this.vjElbow.setRotation(this.qElbow);
        }
    }

    @Override
    public TimedMotionUnit createTMU(BMLBlockPeg bbPeg, String i, String bmlId) {
        return new PointingTMU(bbPeg, i, bmlId, this);
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("target")) {
            this.target = value;
        } else if (name.equals("hand")) {
            this.setHand(value);
        }
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("hand")) {
            return this.hand;
        }
        return null;
    }

    @Override
    public void setParameterValue(String name, float value) {
    }

    public void setTimeManipulator(TimeManipulator tmp) {
        this.tmp = tmp;
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }
}

