/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.motionunit;

import hmi.animation.VJoint;
import hmi.bml.BMLSync;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import hmi.elckerlyc.planunit.RelativeSyncNotFoundException;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TimedMotionUnit
extends TimedAbstractPlanUnit {
    private final MotionUnit mu;
    protected ArrayList<KeyPosition> progressHandled = new ArrayList();
    private final PlanUnitTimeManager puTimeManager;

    public TimedMotionUnit(BMLBlockPeg bmlBlockPeg, String i, String bmlId, MotionUnit m) {
        super(bmlBlockPeg, i, bmlId);
        this.mu = m;
        this.puTimeManager = new PlanUnitTimeManager(this.mu);
    }

    @Override
    public boolean hasValidTiming() {
        return this.puTimeManager.hasValidTiming();
    }

    public Map<KeyPosition, TimePeg> getPegs() {
        return this.puTimeManager.getPegs();
    }

    public KeyPosition getKeyPosition(TimePeg sp) {
        return this.puTimeManager.getKeyPosition(sp);
    }

    public double getPrevPegTime(String pid) {
        return this.puTimeManager.getPrevPegTime(pid);
    }

    public double getNextPegTime(String pid) {
        return this.puTimeManager.getNextPegTime(pid);
    }

    @Override
    public double getTime(String pid) {
        return this.puTimeManager.getPegTime(pid);
    }

    @Override
    public TimePeg getTimePeg(String pid) {
        return this.puTimeManager.getTimePeg(pid);
    }

    @Override
    public double getRelativeTime(String syncId) throws RelativeSyncNotFoundException {
        return this.puTimeManager.getRelativeTime(syncId);
    }

    @Override
    public double getEndTime() {
        return this.puTimeManager.getEndTime();
    }

    @Override
    public void setTimePeg(String kid, TimePeg sp) {
        this.puTimeManager.setTimePeg(kid, sp);
    }

    public void setTimePeg(KeyPosition kp, TimePeg sp) {
        this.puTimeManager.setTimePeg(kp, sp);
    }

    @Override
    public double getStartTime() {
        return this.puTimeManager.getStartTime();
    }

    public TimedMotionUnit getPredictor(VJoint vPredict) {
        MotionUnit muPred = this.mu.getPredictor(vPredict);
        if (muPred != null) {
            TimedMotionUnit copy = muPred.createTMU(this.getBMLBlockPeg(), String.valueOf(this.getId()) + "-pred", this.getBMLId());
            copy.setState(TimedPlanUnitState.LURKING);
            copy.puTimeManager.setPegs(this.puTimeManager.getPegs());
            return copy;
        }
        return null;
    }

    public void resolveDefaultBMLKeyPositions() {
        double left = 0.0;
        double right = 1.0;
        KeyPosition kp = this.getMotionUnit().getKeyPosition(BMLSync.START.getId());
        if (kp == null) {
            this.getMotionUnit().addKeyPosition(new KeyPosition(BMLSync.START.getId(), 0.0, 0.0));
        }
        if ((kp = this.getMotionUnit().getKeyPosition(BMLSync.END.getId())) == null) {
            this.getMotionUnit().addKeyPosition(new KeyPosition(BMLSync.END.getId(), 1.0, 1.0));
        }
        if ((kp = this.getMotionUnit().getKeyPosition(BMLSync.READY.getId())) == null) {
            this.getMotionUnit().addKeyPosition(new KeyPosition(BMLSync.READY.getId(), 0.0, 0.01));
        } else {
            left = kp.time;
        }
        kp = this.getMotionUnit().getKeyPosition(BMLSync.RELAX.getId());
        if (kp == null) {
            this.getMotionUnit().addKeyPosition(new KeyPosition(BMLSync.RELAX.getId(), 1.0, 0.01));
        } else {
            right = kp.time;
        }
        kp = this.getMotionUnit().getKeyPosition(BMLSync.STROKE_START.getId());
        if (kp == null) {
            this.getMotionUnit().addKeyPosition(new KeyPosition(BMLSync.STROKE_START.getId(), left, 0.01));
        } else {
            left = kp.time;
        }
        kp = this.getMotionUnit().getKeyPosition(BMLSync.STROKE_END.getId());
        if (kp == null) {
            this.getMotionUnit().addKeyPosition(new KeyPosition(BMLSync.STROKE_END.getId(), right, 0.01));
        }
        if ((kp = this.getMotionUnit().getKeyPosition(BMLSync.STROKE.getId())) == null) {
            this.getMotionUnit().addKeyPosition(new KeyPosition(BMLSync.STROKE.getId(), left, 0.01));
        }
    }

    public KeyPosition getKeyPosition(String kid) {
        return this.getMotionUnit().getKeyPosition(kid);
    }

    private void sendProgress(double t, double time) {
        for (KeyPosition k : this.mu.getKeyPositions()) {
            if (k.time <= t) {
                if (this.progressHandled.contains(k)) continue;
                String bmlId = this.getBMLId();
                String behaviorId = this.getId();
                String syncId = k.id;
                String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
                double bmlBlockTime = time - this.bmlBlockPeg.getValue();
                this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
                this.progressHandled.add(k);
                continue;
            }
            if (!this.progressHandled.contains(k)) continue;
            this.progressHandled.remove(k);
        }
    }

    @Override
    protected void playUnit(double time) throws TMUPlayException {
        double t = this.puTimeManager.getRelativeTime(time);
        try {
            this.mu.play(t);
        }
        catch (MUPlayException ex) {
            TMUPlayException tpe = new TMUPlayException(ex.getLocalizedMessage(), this);
            tpe.initCause(ex);
            throw tpe;
        }
        this.sendProgress(t, time);
    }

    @Override
    public void stopUnit(double time) {
        if (time < this.getEndTime()) {
            this.sendProgress(this.puTimeManager.getRelativeTime(time), time);
        } else {
            this.sendProgress(1.0, time);
        }
    }

    @Override
    public void resetUnit() {
        this.progressHandled.clear();
    }

    public MotionUnit getMotionUnit() {
        return this.mu;
    }

    @Override
    public String getReplacementGroup() {
        return this.mu.getReplacementGroup();
    }

    @Override
    public double getPreferedDuration() {
        return this.mu.getPreferedDuration();
    }

    @Override
    public List<String> getAvailableSyncs() {
        return this.puTimeManager.getAvailableSyncs();
    }

    @Override
    public void setParameterValue(String paramId, String value) {
        this.mu.setParameterValue(paramId, value);
    }

    @Override
    public void setParameterValue(String paramId, float value) {
        this.mu.setParameterValue(paramId, value);
    }
}

