/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.mixed;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.animationengine.mixed.MixedSystemGenerator;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.assembler.PhysicalHumanoidAssembler;
import hmi.physics.ode.OdeHumanoid;
import hmi.testutil.animation.HanimBody;
import hmi.util.Resources;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.odejava.HashSpace;
import org.odejava.Odejava;
import org.odejava.Space;
import org.odejava.World;

public class MixedSystemGeneratorTest {
    private PhysicalHumanoid fullBodyPh;
    private MixedSystemGenerator mixedSystemGenerator;
    private VJoint human;

    @Before
    public void setup() throws IOException {
        Odejava.init();
        this.fullBodyPh = new OdeHumanoid("Armandia", new World(), (Space)new HashSpace());
        this.human = HanimBody.getLOA1HanimBody();
        PhysicalHumanoidAssembler pha = new PhysicalHumanoidAssembler(this.human, this.fullBodyPh);
        Resources res = new Resources("");
        pha.readXML((Reader)res.getReader("mixedsystemtest/armandia_ph.xml"));
        float[] g = new float[]{0.0f, -9.8f, 0.0f};
        this.mixedSystemGenerator = new MixedSystemGenerator(this.fullBodyPh, g);
    }

    @After
    public void tearDown() {
        Odejava.close();
    }

    @Test
    public void test() {
        ArrayList<String> requiredJoints = new ArrayList<String>();
        requiredJoints.add("r_hip");
        requiredJoints.add("r_knee");
        requiredJoints.add("r_ankle");
        requiredJoints.add("l_hip");
        requiredJoints.add("l_knee");
        requiredJoints.add("l_ankle");
        ArrayList<String> desiredJoints = new ArrayList<String>();
        MixedSystem ms = this.mixedSystemGenerator.generateMixedSystem("Ph1", requiredJoints, desiredJoints, this.human);
        Assert.assertEquals((long)7L, (long)ms.getPHuman().getSegments().length);
        Assert.assertNotNull((Object)ms.getPHuman().getSegment("HumanoidRoot"));
        Assert.assertNotNull((Object)ms.getPHuman().getSegment("r_hip"));
        Assert.assertNotNull((Object)ms.getPHuman().getSegment("r_knee"));
        Assert.assertNotNull((Object)ms.getPHuman().getSegment("r_ankle"));
        Assert.assertNotNull((Object)ms.getPHuman().getSegment("l_hip"));
        Assert.assertNotNull((Object)ms.getPHuman().getSegment("l_knee"));
        Assert.assertNotNull((Object)ms.getPHuman().getSegment("l_ankle"));
    }
}

