/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.keyframe;

import hmi.animation.SkeletonInterpolator;
import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.keyframe.KeyframeMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.testutil.animation.HanimBody;
import hmi.testutil.math.Quat4fTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyframeMUTest {
    private static final double SKI_STARTTIME = 1.0;
    private static final double SKI_ENDTIME = 2.0;
    private static final float[] HUMANOIDROOT_POS = Vec3f.getVec3f((float)0.0f, (float)1.0f, (float)1.0f);
    private static final float[] HUMANOIDROOT_ROT = Quat4f.getQuat4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    private static final float[] L_SHOULDER_ROT = Quat4f.getQuat4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    private static final float[] R_SHOULDER_ROT = Quat4f.getQuat4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    private SkeletonInterpolator ski;
    private VJoint human;
    private KeyframeMU kfmu;

    @Before
    public void setup() {
        String str = "<SkeletonInterpolator rotationEncoding=\"quaternions\" parts=\"HumanoidRoot r_shoulder l_shoulder\" encoding=\"T1R\">1.0 " + HUMANOIDROOT_POS[0] + " " + HUMANOIDROOT_POS[1] + " " + HUMANOIDROOT_POS[2] + " " + HUMANOIDROOT_ROT[0] + " " + HUMANOIDROOT_ROT[1] + " " + HUMANOIDROOT_ROT[2] + " " + HUMANOIDROOT_ROT[3] + " " + L_SHOULDER_ROT[0] + " " + L_SHOULDER_ROT[1] + " " + L_SHOULDER_ROT[2] + " " + L_SHOULDER_ROT[3] + " " + R_SHOULDER_ROT[0] + " " + R_SHOULDER_ROT[1] + " " + R_SHOULDER_ROT[2] + " " + R_SHOULDER_ROT[3] + "\n" + 2.0 + " " + HUMANOIDROOT_POS[0] + " " + HUMANOIDROOT_POS[1] + " " + HUMANOIDROOT_POS[2] + " " + HUMANOIDROOT_ROT[0] + " " + HUMANOIDROOT_ROT[1] + " " + HUMANOIDROOT_ROT[2] + " " + HUMANOIDROOT_ROT[3] + " " + L_SHOULDER_ROT[0] + " " + L_SHOULDER_ROT[1] + " " + L_SHOULDER_ROT[2] + " " + L_SHOULDER_ROT[3] + " " + R_SHOULDER_ROT[0] + " " + R_SHOULDER_ROT[1] + " " + R_SHOULDER_ROT[2] + " " + R_SHOULDER_ROT[3] + " " + "</SkeletonInterpolator>";
        this.ski = new SkeletonInterpolator();
        this.ski.readXML(str);
        this.human = HanimBody.getLOA1HanimBody();
        this.ski.setTarget(this.human);
        this.kfmu = new KeyframeMU(this.ski);
    }

    @Test
    public void testJointFilter() {
        this.human.setRotation(0.0f, 0.0f, 0.0f, 1.0f);
        this.human.getPart("r_shoulder").setRotation(0.0f, 0.0f, 0.0f, 1.0f);
        this.kfmu.setParameterValue("joints", "r_shoulder l_shoulder");
        this.kfmu.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)R_SHOULDER_ROT[0], (float)R_SHOULDER_ROT[1], (float)(-R_SHOULDER_ROT[2]), (float)(-R_SHOULDER_ROT[3]), (float[])q, (float)0.001f);
    }

    @Test
    public void testFilterThenMirror() {
        this.human.setRotation(0.0f, 0.0f, 0.0f, 1.0f);
        this.kfmu.setParameterValue("joints", "l_shoulder");
        this.kfmu.setParameterValue("mirror", "true");
        this.kfmu.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("HumanoidRoot").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float[])q, (float)1.0E-4f);
        this.human.getPart("r_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float[])q, (float)1.0E-4f);
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)R_SHOULDER_ROT[0], (float)R_SHOULDER_ROT[1], (float)(-R_SHOULDER_ROT[2]), (float)(-R_SHOULDER_ROT[3]), (float[])q, (float)0.001f);
    }

    @Test
    public void testMirrorThenFilter() {
        this.human.setRotation(0.0f, 0.0f, 0.0f, 1.0f);
        this.kfmu.setParameterValue("mirror", "true");
        this.kfmu.setParameterValue("joints", "l_shoulder");
        this.kfmu.play(0.0);
        float[] q = Quat4f.getQuat4f();
        this.human.getPart("HumanoidRoot").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float[])q, (float)1.0E-4f);
        this.human.getPart("r_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float[])q, (float)1.0E-4f);
        this.human.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float)R_SHOULDER_ROT[0], (float)R_SHOULDER_ROT[1], (float)(-R_SHOULDER_ROT[2]), (float)(-R_SHOULDER_ROT[3]), (float[])q, (float)0.001f);
    }

    @Test
    public void testCopy() throws MUPlayException {
        VJoint humanCopy = HanimBody.getLOA1HanimBody();
        MotionUnit kfmuCopy = this.kfmu.copy(humanCopy);
        kfmuCopy.play(0.0);
        float[] q = Quat4f.getQuat4f();
        humanCopy.getPart("HumanoidRoot").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])HUMANOIDROOT_ROT, (float[])q, (float)1.0E-4f);
        humanCopy.getPart("r_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])R_SHOULDER_ROT, (float[])q, (float)1.0E-4f);
        humanCopy.getPart("l_shoulder").getRotation(q);
        Quat4fTestUtil.assertQuat4fRotationEquivalent((float[])L_SHOULDER_ROT, (float[])q, (float)1.0E-4f);
        Assert.assertEquals((double)1.0, (double)kfmuCopy.getPreferedDuration(), (double)0.001f);
    }

    @Test
    public void testGetDuration() {
        Assert.assertEquals((double)1.0, (double)this.kfmu.getPreferedDuration(), (double)0.001f);
    }
}

