/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.keyframe;

import hmi.animation.SkeletonInterpolator;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KeyframeMU
implements MotionUnit {
    private SkeletonInterpolator baseIp;
    private SkeletonInterpolator currentIp;
    private HashMap<String, String> parameters = new HashMap();
    private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private boolean mirror = false;
    private Set<String> filter = new HashSet<String>();

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }

    public KeyframeMU(SkeletonInterpolator si) {
        this.baseIp = si;
        this.currentIp = new SkeletonInterpolator(si);
    }

    public void setTarget(VJoint v) {
        this.baseIp.setTarget(v);
        this.currentIp.setTarget(v);
    }

    public Set<String> getJoints() {
        return new HashSet<String>(Arrays.asList(this.currentIp.getPartIds()));
    }

    @Override
    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    @Override
    public double getPreferedDuration() {
        return this.currentIp.getEndTime() - this.currentIp.getStartTime();
    }

    @Override
    public void play(double t) {
        this.currentIp.time(this.currentIp.getStartTime() + this.getPreferedDuration() * t);
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return this.copy(predict);
    }

    private void applyParameters() {
        this.currentIp = new SkeletonInterpolator(this.baseIp);
        if (this.mirror) {
            this.currentIp.mirror();
        }
        if (this.filter.size() > 0) {
            this.currentIp.filterJoints(this.filter);
        }
    }

    public void filterJoints(Set<String> jointFilter) {
        this.filter.clear();
        this.filter.addAll(jointFilter);
        StringBuffer value = new StringBuffer();
        for (String joint : jointFilter) {
            value.append(joint);
            value.append(" ");
        }
        this.parameters.put("joints", value.toString().trim());
        this.applyParameters();
    }

    public SkeletonInterpolator getSkeletonInterpolator() {
        return this.baseIp;
    }

    public MotionUnit copy(VJoint v) {
        VJoint[] empty = new VJoint[]{};
        ArrayList<VJoint> vjParts = new ArrayList<VJoint>();
        String[] stringArray = this.baseIp.getPartIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            for (VJoint vj : v.getParts()) {
                if (!vj.getSid().equals(s)) continue;
                vjParts.add(vj);
            }
            ++n2;
        }
        SkeletonInterpolator ipPredict = new SkeletonInterpolator(this.baseIp, (VObject[])vjParts.toArray(empty));
        KeyframeMU copy = new KeyframeMU(ipPredict);
        for (Map.Entry entry : this.parameters.entrySet()) {
            copy.setParameterValue((String)entry.getKey(), (String)entry.getValue());
        }
        for (KeyPosition keyPosition : this.getKeyPositions()) {
            copy.addKeyPosition(keyPosition);
        }
        return copy;
    }

    @Override
    public void setParameterValue(String name, float value) {
        this.parameters.put(name, "" + value);
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("joints")) {
            String[] joints = value.split("\\s");
            this.filter.clear();
            String[] stringArray = joints;
            int n = joints.length;
            int n2 = 0;
            while (n2 < n) {
                String joint = stringArray[n2];
                this.filter.add(joint);
                ++n2;
            }
            this.applyParameters();
        } else if (name.equals("mirror")) {
            this.mirror = Boolean.parseBoolean(value);
            this.applyParameters();
        }
        this.parameters.put(name, value);
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("mirror")) {
            return "false";
        }
        return this.parameters.get(name);
    }

    @Override
    public TimedMotionUnit createTMU(BMLBlockPeg bbPeg, String i, String bmlId) {
        return new TimedMotionUnit(bbPeg, i, bmlId, this);
    }

    @Override
    public MotionUnit copy(AnimationPlayer p) {
        return this.copy(p.getVNext());
    }

    @Override
    public String getReplacementGroup() {
        return this.getParameterValue("replacementgroup");
    }
}

