/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.testutil.animation.HanimBody;
import hmi.util.Resources;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpeechBindingTest {
    private SpeechBinding speechBinding;
    @Mocked
    AnimationPlayer mockAniPlayer;
    private VJoint human;

    @Before
    public void setup() {
        this.speechBinding = new SpeechBinding(new Resources(""));
        this.human = HanimBody.getLOA1HanimBody();
    }

    @Test
    public void testReadXML() {
        String str = "<speechbinding><VisimeSpec visime=\"0\"><parameterdefaults><parameterdefault name=\"a\" value=\"0\"/></parameterdefaults><MotionUnit type=\"ProcAnimation\" file=\"procanimation/speech/speakjaw.xml\"/></VisimeSpec><VisimeSpec visime=\"1\"><parameterdefaults><parameterdefault name=\"a\" value=\"1\"/></parameterdefaults><MotionUnit type=\"ProcAnimation\" file=\"procanimation/speech/speakjaw.xml\"/></VisimeSpec></speechbinding>";
        this.speechBinding.readXML(str);
        VJoint h = this.human;
        new NonStrictExpectations(h){
            {
                SpeechBindingTest.this.mockAniPlayer.getVNext();
                this.returns(vJoint);
            }
        };
        TimedMotionUnit tmu = this.speechBinding.getMotionUnit(0, BMLBlockPeg.GLOBALPEG, "speech1", "bml1", this.mockAniPlayer);
        Assert.assertEquals((Object)"bml1", (Object)tmu.getBMLId());
        Assert.assertEquals((Object)"speech1", (Object)tmu.getId());
        Assert.assertEquals((double)0.0, (double)Float.parseFloat(tmu.getMotionUnit().getParameterValue("a")), (double)0.001f);
        tmu = this.speechBinding.getMotionUnit(1, BMLBlockPeg.GLOBALPEG, "speech1", "bml1", this.mockAniPlayer);
        Assert.assertEquals((Object)"bml1", (Object)tmu.getBMLId());
        Assert.assertEquals((Object)"speech1", (Object)tmu.getId());
        Assert.assertEquals((double)1.0, (double)Float.parseFloat(tmu.getMotionUnit().getParameterValue("a")), (double)0.001f);
    }
}

