/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.animation.VJoint;
import hmi.bml.core.Behaviour;
import hmi.bml.core.HeadBehaviour;
import hmi.bml.ext.bmlt.BMLTKeyframeBehaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.testutil.animation.HanimBody;
import hmi.util.Resources;
import java.util.List;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GestureBindingTest {
    @Mocked
    AnimationPlayer mockAniPlayer;
    private VJoint human;

    @Before
    public void setup() {
        this.human = HanimBody.getLOA1HanimBody();
    }

    @Test
    public void testReadXML() {
        Resources r = new Resources("");
        GestureBinding g = new GestureBinding(r);
        String s = "<gesturebinding><MotionUnitSpec type=\"head\"><constraints><constraint name=\"action\" value=\"ROTATION\"/><constraint name=\"rotation\" value=\"NOD\"/></constraints><parametermap><parameter src=\"amount\" dst=\"a\"/><parameter src=\"repeats\" dst=\"r\"/></parametermap><MotionUnit type=\"ProcAnimation\" file=\"procanimation/smartbody/nod.xml\"/></MotionUnitSpec><MotionUnitSpec type=\"head\"><constraints><constraint name=\"action\" value=\"ROTATION\"/><constraint name=\"rotation\" value=\"SHAKE\"/></constraints><parametermap><parameter src=\"amount\" dst=\"a\"/><parameter src=\"repeats\" dst=\"r\"/></parametermap><MotionUnit type=\"ProcAnimation\" file=\"procanimation/smartbody/shake.xml\"/></MotionUnitSpec></gesturebinding>";
        g.readXML(s);
        HeadBehaviour b = new HeadBehaviour();
        b.readXML("<head id=\"head1\" action=\"ROTATION\" rotation=\"NOD\" amount=\"2\"/>");
        VJoint h = this.human;
        new NonStrictExpectations(h){
            {
                GestureBindingTest.this.mockAniPlayer.getVNext();
                this.returns(vJoint);
            }
        };
        BMLBlockPeg bbPeg = BMLBlockPeg.GLOBALPEG;
        List<TimedMotionUnit> m = g.getMotionUnit(bbPeg, (Behaviour)b, this.mockAniPlayer);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Float.parseFloat(m.get(0).getMotionUnit().getParameterValue("r")) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((Float.parseFloat(m.get(0).getMotionUnit().getParameterValue("a")) == 2.0f ? 1 : 0) != 0);
        b = new HeadBehaviour();
        b.readXML("<head id=\"head1\" action=\"ROTATION\" rotation=\"NOD\" repeats=\"2\"/>");
        b.bmlId = "bml1";
        m = g.getMotionUnit(bbPeg, (Behaviour)b, this.mockAniPlayer);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Float.parseFloat(m.get(0).getMotionUnit().getParameterValue("r")) == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Float.parseFloat(m.get(0).getMotionUnit().getParameterValue("a")) == 0.5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)m.get(0).getBMLId(), (Object)"bml1");
        Assert.assertEquals((Object)m.get(0).getId(), (Object)"head1");
        b = new HeadBehaviour();
        b.readXML("<head id=\"head1\" action=\"ROTATION\" rotation=\"SHAKE\" repeats=\"2\"/>");
        b.bmlId = "bml1";
        m = g.getMotionUnit(bbPeg, (Behaviour)b, this.mockAniPlayer);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((double)2.0, (double)Float.parseFloat(m.get(0).getMotionUnit().getParameterValue("r")), (double)0.001);
        Assert.assertEquals((double)0.5, (double)Float.parseFloat(m.get(0).getMotionUnit().getParameterValue("a")), (double)0.001);
        Assert.assertEquals((Object)m.get(0).getBMLId(), (Object)"bml1");
        Assert.assertEquals((Object)m.get(0).getId(), (Object)"head1");
    }

    @Test
    public void testReadKeyframe() {
        String s = "<gesturebinding><MotionUnitSpec type=\"keyframe\" namespace=\"http://hmi.ewi.utwente.nl/bmlt\"><constraints><constraint name=\"name\" value=\"vlakte\"/></constraints><MotionUnit type=\"Keyframe\" file=\"keyframe/clench_fists.xml\"/></MotionUnitSpec></gesturebinding>";
        Resources r = new Resources("");
        GestureBinding g = new GestureBinding(r);
        g.readXML(s);
        BMLTKeyframeBehaviour b = new BMLTKeyframeBehaviour();
        b.readXML("<keyframe xmlns=\"http://hmi.ewi.utwente.nl/bmlt\" id=\"v1\" name=\"vlakte\"><parameter name=\"joints\" value=\"r_shoulder r_elbow r_wrist\"/></keyframe>");
        b.bmlId = "bml1";
        VJoint h = this.human;
        new NonStrictExpectations(h){
            {
                GestureBindingTest.this.mockAniPlayer.getVNext();
                this.returns(vJoint);
            }
        };
        List<TimedMotionUnit> m = g.getMotionUnit(BMLBlockPeg.GLOBALPEG, (Behaviour)b, this.mockAniPlayer);
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertEquals((Object)"bml1", (Object)m.get(0).getBMLId());
        Assert.assertEquals((Object)"v1", (Object)m.get(0).getId());
    }
}

