/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.controller;

import hmi.elckerlyc.animationengine.controller.CompoundController;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.controller.PhysicalController;
import mockit.Mocked;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompoundControllerTest {
    private CompoundController compoundController;
    @Mocked
    private PhysicalHumanoid mockPhysicalHumanoid;

    @Before
    public void setup() {
        this.compoundController = new CompoundController();
        String str = "<CompoundController xmlns:bmlt=\"http://hmi.ewi.utwente.nl/bmlt\"><required><Controller class=\"hmi.physics.controller.HingeJointController\" id=\"elbow\"><bmlt:parameter name=\"joint\" value=\"l_elbow\"/><bmlt:parameter name=\"ds\" value=\"1\"/><bmlt:parameter name=\"ks\" value=\"200\"/><bmlt:parameter name=\"angle\" value=\"3\"/></Controller></required><desired><Controller class=\"hmi.physics.controller.HingeJointController\" id=\"wrist\"><bmlt:parameter name=\"joint\" value=\"l_wrist\"/><bmlt:parameter name=\"ds\" value=\"2\"/><bmlt:parameter name=\"ks\" value=\"100\"/><bmlt:parameter name=\"angle\" value=\"1\"/></Controller><Controller class=\"hmi.physics.controller.HingeJointController\" id=\"thumb\"><bmlt:parameter name=\"joint\" value=\"l_thumb1\"/></Controller><Controller class=\"hmi.physics.controller.HingeJointController\" id=\"elbow\"><bmlt:parameter name=\"joint\" value=\"l_elbow\"/></Controller></desired></CompoundController>";
        this.compoundController.readXML(str);
    }

    @Test
    public void testGetParameterValue() {
        Assert.assertEquals((Object)"l_elbow", (Object)this.compoundController.getParameterValue("elbow:joint"));
        Assert.assertEquals((double)1.0, (double)Float.parseFloat(this.compoundController.getParameterValue("elbow:ds")), (double)0.001);
        Assert.assertEquals((double)200.0, (double)Float.parseFloat(this.compoundController.getParameterValue("elbow:ks")), (double)0.001);
        Assert.assertEquals((double)3.0, (double)Float.parseFloat(this.compoundController.getParameterValue("elbow:angle")), (double)0.001);
        Assert.assertEquals((Object)"l_wrist", (Object)this.compoundController.getParameterValue("wrist:joint"));
        Assert.assertEquals((double)2.0, (double)Float.parseFloat(this.compoundController.getParameterValue("wrist:ds")), (double)0.001);
        Assert.assertEquals((double)100.0, (double)Float.parseFloat(this.compoundController.getParameterValue("wrist:ks")), (double)0.001);
        Assert.assertEquals((double)1.0, (double)Float.parseFloat(this.compoundController.getParameterValue("wrist:angle")), (double)0.001);
    }

    @Test
    public void testGetJointIDs() {
        Assert.assertThat((Object)this.compoundController.getRequiredJointIDs(), (Matcher)IsArrayContaining.hasItemInArray((Object)"l_elbow"));
        Assert.assertEquals((long)1L, (long)this.compoundController.getRequiredJointIDs().length);
        Assert.assertThat((Object)this.compoundController.getDesiredJointIDs(), (Matcher)IsArrayContaining.hasItemInArray((Object)"l_wrist"));
        Assert.assertThat((Object)this.compoundController.getDesiredJointIDs(), (Matcher)IsArrayContaining.hasItemInArray((Object)"l_thumb1"));
        Assert.assertThat((Object)this.compoundController.getDesiredJointIDs(), (Matcher)IsArrayContaining.hasItemInArray((Object)"l_elbow"));
        Assert.assertEquals((long)3L, (long)this.compoundController.getDesiredJointIDs().length);
    }

    @Test
    public void testCopy() {
        PhysicalController cCopy = this.compoundController.copy(this.mockPhysicalHumanoid);
        Assert.assertEquals((Object)"l_elbow", (Object)cCopy.getParameterValue("elbow:joint"));
        Assert.assertEquals((double)1.0, (double)Float.parseFloat(cCopy.getParameterValue("elbow:ds")), (double)0.001);
        Assert.assertEquals((double)200.0, (double)Float.parseFloat(cCopy.getParameterValue("elbow:ks")), (double)0.001);
        Assert.assertEquals((double)3.0, (double)Float.parseFloat(cCopy.getParameterValue("elbow:angle")), (double)0.001);
        Assert.assertEquals((Object)"l_wrist", (Object)cCopy.getParameterValue("wrist:joint"));
        Assert.assertEquals((double)2.0, (double)Float.parseFloat(cCopy.getParameterValue("wrist:ds")), (double)0.001);
        Assert.assertEquals((double)100.0, (double)Float.parseFloat(cCopy.getParameterValue("wrist:ks")), (double)0.001);
        Assert.assertEquals((double)1.0, (double)Float.parseFloat(cCopy.getParameterValue("wrist:angle")), (double)0.001);
    }
}

