/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.VJoint;
import hmi.bml.BMLSync;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.planunit.RelativeSyncNotFoundException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import java.util.List;
import mockit.Mock;
import mockit.NonStrictExpectations;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimedMotionUnitTest {
    private MotionUnit muMock;
    private List<BMLSyncPointProgressFeedback> fbList;
    private ListFeedbackListener fbl;
    private TimedMotionUnit tmu;

    @Before
    public void setup() {
        this.fbList = new ArrayList<BMLSyncPointProgressFeedback>();
        this.fbl = new ListFeedbackListener(this.fbList);
        this.muMock = new StubMotionUnit();
        this.tmu = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock);
        this.tmu.addFeedbackListener((BMLFeedbackListener)this.fbl);
    }

    private void assertEqualBMLSyncPointProgressFeedback(BMLSyncPointProgressFeedback expected, BMLSyncPointProgressFeedback actual) {
        Assert.assertEquals((Object)expected.behaviorId, (Object)actual.behaviorId);
        Assert.assertEquals((Object)expected.bmlId, (Object)actual.bmlId);
        Assert.assertEquals((Object)expected.syncId, (Object)actual.syncId);
        Assert.assertEquals((double)expected.bmlBlockTime, (double)actual.bmlBlockTime, (double)0.01);
        Assert.assertEquals((double)expected.timeStamp, (double)actual.timeStamp, (double)0.01);
    }

    @Test
    public void testGetAvailableSyncs() {
        this.tmu.resolveDefaultBMLKeyPositions();
        MatcherAssert.assertThat(this.tmu.getAvailableSyncs(), (Matcher)Matchers.contains((Object[])new String[]{"start", "ready", "stroke_start", "stroke", "stroke_end", "relax", "end"}));
    }

    @Test
    public void getRelativeTime() throws RelativeSyncNotFoundException {
        this.muMock.addKeyPosition(new KeyPosition("stroke", 0.4, 1.0));
        Assert.assertEquals((double)0.4, (double)this.tmu.getRelativeTime("stroke"), (double)0.01);
    }

    @Test
    public void getRelativeTimeResolved() throws RelativeSyncNotFoundException {
        this.muMock.addKeyPosition(new KeyPosition(BMLSync.STROKE.getId(), 0.4, 1.0));
        this.tmu.resolveDefaultBMLKeyPositions();
        Assert.assertEquals((double)0.0, (double)this.tmu.getRelativeTime(BMLSync.START.getId()), (double)0.01);
        Assert.assertEquals((double)0.0, (double)this.tmu.getRelativeTime(BMLSync.READY.getId()), (double)0.01);
        Assert.assertEquals((double)0.0, (double)this.tmu.getRelativeTime(BMLSync.STROKE_START.getId()), (double)0.01);
        Assert.assertEquals((double)0.4, (double)this.tmu.getRelativeTime(BMLSync.STROKE.getId()), (double)0.01);
        Assert.assertEquals((double)1.0, (double)this.tmu.getRelativeTime(BMLSync.STROKE_END.getId()), (double)0.01);
        Assert.assertEquals((double)1.0, (double)this.tmu.getRelativeTime(BMLSync.RELAX.getId()), (double)0.01);
        Assert.assertEquals((double)1.0, (double)this.tmu.getRelativeTime(BMLSync.END.getId()), (double)0.01);
        Assert.assertEquals((double)1.0, (double)this.tmu.getRelativeTime("end"), (double)0.01);
    }

    @Test
    public void testPrepState() throws TimedPlanUnitPlayException, MUPlayException {
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(anyDouble);
                times = 0;
            }
        };
        this.tmu.setTimePeg("start", tp);
        this.tmu.play(1.0);
        Assert.assertTrue((boolean)this.fbList.isEmpty());
    }

    @Test
    public void testReset() throws MUPlayException, TimedPlanUnitPlayException {
        this.tmu.setState(TimedPlanUnitState.LURKING);
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(anyDouble);
                times = 1;
            }
        };
        this.tmu.start(1.0);
        this.tmu.setTimePeg("start", tp);
        this.tmu.play(1.0);
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "start", 1.0, 1.0), this.fbList.get(0));
        Assert.assertEquals((long)1L, (long)this.fbList.size());
        this.tmu.reset();
        Assert.assertEquals((Object)((Object)TimedPlanUnitState.LURKING), (Object)((Object)this.tmu.getState()));
        Assert.assertEquals((long)1L, (long)this.fbList.size());
    }

    @Test
    public void testStop() throws MUPlayException, TimedPlanUnitPlayException {
        this.tmu.setState(TimedPlanUnitState.LURKING);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(10.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(anyDouble);
                times = 1;
            }
        };
        this.tmu.start(1.0);
        this.tmu.setTimePeg("start", tpStart);
        this.tmu.setTimePeg("end", tpEnd);
        this.tmu.play(1.0);
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "start", 1.0, 1.0), this.fbList.get(0));
        Assert.assertEquals((long)1L, (long)this.fbList.size());
        this.tmu.stop(5.0);
        Assert.assertEquals((Object)((Object)TimedPlanUnitState.DONE), (Object)((Object)this.tmu.getState()));
        Assert.assertEquals((long)1L, (long)this.fbList.size());
    }

    @Test
    public void testExecStatesPersistant1() throws TimedPlanUnitPlayException, MUPlayException {
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(0.0);
                times = 1;
            }
        };
        this.tmu.setTimePeg("start", tp);
        this.tmu.setState(TimedPlanUnitState.IN_EXEC);
        this.tmu.play(1.0);
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "start", 1.0, 1.0), this.fbList.get(0));
        Assert.assertEquals((long)1L, (long)this.fbList.size());
    }

    @Test
    public void testExecStates() throws TimedPlanUnitPlayException, MUPlayException {
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("stroke", 0.5, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(this.withEqual(0.5, 0.4));
                minTimes = 1;
                maxTimes = 1;
            }
        };
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp2.setGlobalValue(1.0);
        this.tmu.setTimePeg("stroke", tp2);
        this.tmu.setTimePeg("start", tp);
        this.tmu.setState(TimedPlanUnitState.SUBSIDING);
        this.tmu.play(0.5);
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "start", 0.5, 0.5), this.fbList.get(0));
        Assert.assertEquals((long)1L, (long)this.fbList.size());
    }

    @Test
    public void testExecStatesPersistant2() throws TimedPlanUnitPlayException, MUPlayException {
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("stroke", 0.5, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(this.withEqual(0.5, 0.001));
                times = 1;
            }
        };
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp2.setGlobalValue(1.0);
        this.tmu.setTimePeg("stroke", tp2);
        this.tmu.setTimePeg("start", tp);
        this.tmu.setState(TimedPlanUnitState.SUBSIDING);
        this.tmu.play(1.0);
    }

    @Test
    public void testExecStatesPersistant3() throws TimedPlanUnitPlayException, MUPlayException {
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("stroke", 0.5, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(0.5);
                times = 1;
            }
        };
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp2.setGlobalValue(1.0);
        this.tmu.setTimePeg("stroke", tp2);
        this.tmu.setTimePeg("start", tp);
        this.tmu.setState(TimedPlanUnitState.SUBSIDING);
        this.tmu.play(3.0);
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "start", 3.0, 3.0), this.fbList.get(0));
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "stroke", 3.0, 3.0), this.fbList.get(1));
        Assert.assertEquals((long)2L, (long)this.fbList.size());
    }

    @Test
    public void testExecStatesEndTimed() throws TimedPlanUnitPlayException, MUPlayException {
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("stroke", 0.5, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(this.withEqual(1.0f, 0.1));
                times = 1;
            }
        };
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp2.setGlobalValue(1.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(2.0);
        this.tmu.setTimePeg("end", tpEnd);
        this.tmu.setTimePeg("stroke", tp2);
        this.tmu.setTimePeg("start", tp);
        this.tmu.setState(TimedPlanUnitState.LURKING);
        this.tmu.start(1.99);
        this.tmu.play(1.99);
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "start", 1.99, 1.99), this.fbList.get(0));
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "stroke", 1.99, 1.99), this.fbList.get(1));
        Assert.assertEquals((long)2L, (long)this.fbList.size());
    }

    @Test
    public void testExecStatesPastEndTime() throws TimedPlanUnitPlayException, MUPlayException {
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(0.0);
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("stroke", 0.5, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(anyDouble);
                times = 0;
            }
        };
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp2.setGlobalValue(1.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(2.0);
        this.tmu.setTimePeg("end", tpEnd);
        this.tmu.setTimePeg("stroke", tp2);
        this.tmu.setTimePeg("start", tp);
        this.tmu.setState(TimedPlanUnitState.SUBSIDING);
        this.tmu.play(3.0);
        Assert.assertTrue((boolean)this.tmu.isDone());
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "start", 3.0, 3.0), this.fbList.get(0));
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "stroke", 3.0, 3.0), this.fbList.get(1));
        this.assertEqualBMLSyncPointProgressFeedback(new BMLSyncPointProgressFeedback("", "bml1", "behaviour1", "end", 3.0, 3.0), this.fbList.get(2));
        Assert.assertEquals((long)3L, (long)this.fbList.size());
    }

    @Test
    public void testHasValidTiming() throws MUPlayException {
        this.muMock.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("stroke", 0.5, 1.0));
        this.muMock.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        new NonStrictExpectations(new Object[]{StubMotionUnit.class}){
            {
                TimedMotionUnitTest.this.muMock.play(anyDouble);
                times = 0;
            }
        };
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(1.0);
        TimePeg tpStroke = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStroke.setGlobalValue(2.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(3.0);
        this.tmu.setTimePeg("start", tpStart);
        this.tmu.setTimePeg("stroke", tpStroke);
        this.tmu.setTimePeg("end", tpEnd);
        Assert.assertTrue((boolean)this.tmu.hasValidTiming());
        tpStroke.setGlobalValue(2.0);
        Assert.assertTrue((boolean)this.tmu.hasValidTiming());
        tpStroke.setGlobalValue(1.0);
        Assert.assertTrue((boolean)this.tmu.hasValidTiming());
        tpStroke.setGlobalValue(3.1);
        Assert.assertTrue((!this.tmu.hasValidTiming() ? 1 : 0) != 0);
        tpStroke.setGlobalValue(2.0);
        tpEnd.setGlobalValue(1.9);
        Assert.assertTrue((!this.tmu.hasValidTiming() ? 1 : 0) != 0);
    }

    private static class StubMotionUnit
    implements MotionUnit {
        private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();

        private StubMotionUnit() {
        }

        @Override
        public void addKeyPosition(KeyPosition kp) {
            this.keyPositionManager.addKeyPosition(kp);
        }

        @Override
        public List<KeyPosition> getKeyPositions() {
            return this.keyPositionManager.getKeyPositions();
        }

        @Override
        public void setKeyPositions(List<KeyPosition> p) {
            this.keyPositionManager.setKeyPositions(p);
        }

        @Override
        public KeyPosition getKeyPosition(String id) {
            return this.keyPositionManager.getKeyPosition(id);
        }

        @Override
        public void removeKeyPosition(String id) {
            this.keyPositionManager.removeKeyPosition(id);
        }

        @Override
        @Mock
        public void setParameterValue(String name, float value) {
        }

        @Override
        @Mock
        public void setParameterValue(String name, String value) {
        }

        @Override
        @Mock
        public String getParameterValue(String name) {
            return null;
        }

        @Override
        @Mock
        public void play(double t) throws MUPlayException {
        }

        @Override
        @Mock
        public TimedMotionUnit createTMU(BMLBlockPeg bmlBlockPeg, String i, String bmlId) {
            return null;
        }

        @Override
        @Mock
        public MotionUnit getPredictor(VJoint vPredict) {
            return null;
        }

        @Override
        @Mock
        public double getPreferedDuration() {
            return 0.0;
        }

        @Override
        @Mock
        public MotionUnit copy(AnimationPlayer p) {
            return null;
        }

        @Override
        @Mock
        public String getReplacementGroup() {
            return null;
        }
    }
}

