/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.physics.PhysicalHumanoid;
import hmi.testutil.animation.HanimBody;
import hmi.testutil.bml.feedback.ListBMLExceptionListener;
import java.util.ArrayList;
import java.util.List;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnimationPlayerTest {
    private AnimationPlayer animationPlayer;
    private List<BMLExceptionFeedback> beList;
    @Mocked
    private TimedPlanUnit mockPlanUnit;
    @Mocked
    private PhysicalHumanoid mockPhysicalHumanoid;
    @Mocked
    private TimedMotionUnit mockTimedMotionUnit;

    @Before
    public void setup() {
        ArrayList<MixedSystem> m = new ArrayList<MixedSystem>();
        float[] g = new float[]{0.0f, 0.0f, 0.0f};
        MixedSystem mix = new MixedSystem(g, this.mockPhysicalHumanoid);
        m.add(mix);
        this.animationPlayer = new AnimationPlayer(HanimBody.getLOA1HanimBody(), HanimBody.getLOA1HanimBody(), HanimBody.getLOA1HanimBody(), HanimBody.getLOA1HanimBody(), m, 0.01f);
        this.beList = new ArrayList<BMLExceptionFeedback>();
        this.animationPlayer.addExceptionListener((BMLExceptionListener)new ListBMLExceptionListener(this.beList));
    }

    @Test
    public void testWarning() {
        this.animationPlayer.puException(this.mockPlanUnit, "blah", 0.0);
        Assert.assertEquals((long)1L, (long)this.beList.size());
    }

    @Test
    public void testPlanUnitException() throws TimedPlanUnitPlayException {
        this.animationPlayer.addTimedMotionUnit(this.mockTimedMotionUnit);
        new NonStrictExpectations(){
            {
                AnimationPlayerTest.this.mockTimedMotionUnit.getId();
                this.returns("id1");
                AnimationPlayerTest.this.mockTimedMotionUnit.getBMLId();
                this.returns("id1");
                AnimationPlayerTest.this.mockTimedMotionUnit.getStartTime();
                this.returns(0.0);
                AnimationPlayerTest.this.mockTimedMotionUnit.getEndTime();
                this.returns(1.0);
                AnimationPlayerTest.this.mockTimedMotionUnit.getState();
                this.returns((Object)TimedPlanUnitState.IN_EXEC);
                AnimationPlayerTest.this.mockTimedMotionUnit.isPlaying();
                this.returns(true);
                AnimationPlayerTest.this.mockTimedMotionUnit.play(anyDouble);
                times = 1;
                result = new TimedPlanUnitPlayException("", AnimationPlayerTest.this.mockTimedMotionUnit);
            }
        };
        this.animationPlayer.step(0.0f);
        Assert.assertEquals((long)1L, (long)this.beList.size());
    }
}

