/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.SkeletonPose;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.animation.VObjectTransformCopier;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.ExceptionManager;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.animationengine.mixed.MixedPlayer;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.planunit.PUExceptionCallback;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.controller.PhysicalController;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationPlayer
implements PUExceptionCallback,
Player {
    private VJoint vPrev;
    private VJoint vCurr;
    private VJoint vNext;
    private VJoint vPredict;
    private PhysicalHumanoid pHuman;
    private VObjectTransformCopier votcCurrToPrev;
    private VObjectTransformCopier votcNextToCurr;
    private boolean prevValid;
    private ArrayList<PhysicalController> controllers = new ArrayList();
    private PlanPlayer app;
    private PlanPlayer appPredict;
    private ArrayList<MixedSystem> mSystems;
    private MixedPlayer mPlayer;
    private float stepTime;
    private SkeletonPose vPrevStartPose;
    private SkeletonPose vCurrStartPose;
    private SkeletonPose vNextStartPose;
    private boolean prevValidOld = false;
    protected WorldObjectManager woManager;
    private List<TimedPlanUnit> tmuRemove = new ArrayList<TimedPlanUnit>();
    private Logger logger = LoggerFactory.getLogger((String)AnimationPlayer.class.getName());
    private final ExceptionManager warningManager = new ExceptionManager();

    public AnimationPlayer(VJoint vP, VJoint vC, VJoint vN, VJoint vPred, ArrayList<MixedSystem> m, float h) {
        this(vP, vC, vN, vPred, m, h, null);
    }

    public AnimationPlayer(VJoint vP, VJoint vC, VJoint vN, VJoint vPred, ArrayList<MixedSystem> m, float h, WorldObjectManager wom) {
        this.vPrev = vP;
        this.vCurr = vC;
        this.vNext = vN;
        this.woManager = wom;
        this.vPredict = vPred;
        VJoint[] emptyArray = new VJoint[]{};
        this.vPrevStartPose = new SkeletonPose((VObject[])this.vPrev.getParts().toArray(emptyArray), "TR");
        this.vCurrStartPose = new SkeletonPose((VObject[])this.vCurr.getParts().toArray(emptyArray), "TR");
        this.vNextStartPose = new SkeletonPose((VObject[])this.vNext.getParts().toArray(emptyArray), "TR");
        this.vPrevStartPose.setFromTarget();
        this.vCurrStartPose.setFromTarget();
        this.vNextStartPose.setFromTarget();
        this.mSystems = m;
        this.pHuman = this.mSystems.get(0).getPHuman();
        this.pHuman.setEnabled(true);
        this.votcNextToCurr = VObjectTransformCopier.newInstanceFromVJointTree((VJoint)this.vNext, (VJoint)this.vCurr, (String)"T1R");
        this.votcCurrToPrev = VObjectTransformCopier.newInstanceFromVJointTree((VJoint)this.vCurr, (VJoint)this.vPrev, (String)"T1R");
        this.mPlayer = new MixedPlayer(this.mSystems.get(0), this.vPrev, this.vCurr, this.vNext);
        this.mPlayer.setH(h);
        this.stepTime = h;
        this.app = new PlanPlayer();
        this.appPredict = new PlanPlayer();
        this.prevValid = false;
    }

    public synchronized int getNumberOfTimedMotionUnits() {
        return this.app.getNumberOfPlanUnits();
    }

    public synchronized void interruptTimedMotionUnit(String id, String bmlId, double globalTime) {
        this.app.interruptPlanUnit(id, bmlId, globalTime);
        this.appPredict.interruptPlanUnit(id, bmlId, 0.0);
    }

    public WorldObjectManager getWoManager() {
        return this.woManager;
    }

    public synchronized void addTimedMotionUnit(TimedMotionUnit tmu) {
        this.app.addPlanUnit(tmu);
        TimedMotionUnit tmuPred = tmu.getPredictor(this.vPredict);
        if (tmuPred != null) {
            this.appPredict.addPlanUnit(tmuPred);
        }
    }

    public synchronized void predict(double time) {
        this.logger.debug("Predicting at {}", (Object)time);
        this.appPredict.play(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset() {
        this.prevValid = false;
        this.vPrevStartPose.setToTarget();
        this.vCurrStartPose.setToTarget();
        this.vNextStartPose.setToTarget();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            for (PhysicalController p : this.controllers) {
                p.reset();
            }
            for (MixedSystem ms : this.mSystems) {
                ms.reset(this.vNext);
            }
        }
        this.app.reset();
    }

    public Set<String> getInvalidBehaviors() {
        return this.app.getInvalidBehaviors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setResetPose() {
        this.vNextStartPose.setFromTarget();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            for (MixedSystem ms : this.mSystems) {
                ms.setResetPose(this.vNext);
                ms.reset(this.vNext);
            }
        }
    }

    public synchronized void exception(BMLExceptionFeedback e) {
        this.warningManager.exception(e);
    }

    @Override
    public synchronized void addExceptionListener(BMLExceptionListener ws) {
        this.warningManager.addExceptionListener(ws);
    }

    @Override
    public synchronized void removeAllExceptionListeners() {
        this.warningManager.removeAllExceptionListeners();
    }

    @Override
    public void puException(TimedPlanUnit timedMU, String message, double time) {
        this.tmuRemove.add(timedMU);
        this.warningManager.puException(timedMU, message, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void step(float prevTime) {
        int n;
        Object object;
        this.controllers.clear();
        this.prevValidOld = this.prevValid;
        this.tmuRemove.clear();
        if (this.prevValid) {
            this.votcCurrToPrev.copyConfig();
            this.votcNextToCurr.copyConfig();
            this.app.play(prevTime, this);
        } else {
            this.app.play(prevTime, this);
            this.votcNextToCurr.copyConfig();
            this.votcCurrToPrev.copyConfig();
            this.prevValid = true;
        }
        for (TimedPlanUnit tmuR : this.tmuRemove) {
            this.interruptTimedMotionUnit(tmuR.getId(), tmuR.getBMLId(), prevTime);
        }
        ArrayList<Object> controlledJoints = new ArrayList<Object>();
        for (PhysicalController p : this.controllers) {
            object = p.getRequiredJointIDs();
            n = ((String[])object).length;
            int n2 = 0;
            while (n2 < n) {
                String jid = object[n2];
                if (!controlledJoints.contains(jid)) {
                    controlledJoints.add(jid);
                }
                ++n2;
            }
        }
        ArrayList<Object> desiredJoints = new ArrayList<Object>();
        for (PhysicalController p : this.controllers) {
            String[] stringArray = p.getDesiredJointIDs();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                Object jid = stringArray[n];
                if (!desiredJoints.contains(jid) && !controlledJoints.contains(jid)) {
                    desiredJoints.add(jid);
                }
                ++n;
            }
        }
        MixedSystem bestMatch = this.mPlayer.getSystem();
        int jointsInPH = Integer.MAX_VALUE;
        int nrOfDesiredJoints = -1;
        boolean foundMatch = false;
        for (MixedSystem m : this.mSystems) {
            void var12_19;
            PhysicalHumanoid ph = m.getPHuman();
            boolean foundAll = true;
            for (String string : controlledJoints) {
                boolean found = false;
                if (ph.getRootSegment() != null && ph.getRootSegment().getSid().equals(string)) {
                    found = true;
                    break;
                }
                for (PhysicalJoint pj : ph.getJoints()) {
                    if (!pj.getName().equals(string)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAll = false;
                break;
            }
            if (!foundAll) continue;
            boolean bl = false;
            block11: for (String string : desiredJoints) {
                if (ph.getRootSegment() != null && ph.getRootSegment().getSid().equals(string)) {
                    ++var12_19;
                    continue;
                }
                for (PhysicalJoint pj : ph.getJoints()) {
                    if (!pj.getName().equals(string)) continue;
                    ++var12_19;
                    continue block11;
                }
            }
            if (var12_19 > nrOfDesiredJoints) {
                nrOfDesiredJoints = var12_19;
                bestMatch = m;
                jointsInPH = ph.getJoints().size();
                foundMatch = true;
                continue;
            }
            if (var12_19 != nrOfDesiredJoints || ph.getJoints().size() >= jointsInPH) continue;
            bestMatch = m;
            jointsInPH = ph.getJoints().size();
            foundMatch = true;
        }
        object = PhysicsSync.getSync();
        synchronized (object) {
            if (!foundMatch) {
                this.logger.warn("Could not find a mixed system that contains joints: {} ", controlledJoints);
            }
            if (bestMatch != this.mPlayer.getSystem()) {
                this.logger.debug("Switching system {}", (Object)Float.valueOf(prevTime));
                this.mPlayer.switchSystem(bestMatch, this.stepTime, this.vPrev, this.vCurr, this.vNext, this.prevValidOld);
                this.pHuman.setEnabled(false);
                this.pHuman = this.mPlayer.getSystem().getPHuman();
                this.pHuman.setEnabled(true);
                for (PhysicalController p : this.controllers) {
                    p.setPhysicalHumanoid(this.pHuman);
                }
            }
            this.mPlayer.play(this.stepTime);
            this.pHuman.updateCOM(this.stepTime);
            for (PhysicalController p : this.controllers) {
                p.setPhysicalHumanoid(this.pHuman);
                p.update((double)this.stepTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyPhysics() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.pHuman.copy();
            float[] q = new float[4];
            float[] tr = new float[3];
            PhysicalSegment[] physicalSegmentArray = this.pHuman.getSegments();
            int n = physicalSegmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                PhysicalSegment ps = physicalSegmentArray[n2];
                VJoint vC = this.vCurr.getPart(ps.getSid());
                VJoint vN = this.vNext.getPart(ps.getSid());
                vC.getRotation(q);
                vN.setRotation(q);
                if (ps.getSid().equals("HumanoidRoot")) {
                    vC.getTranslation(tr);
                    vN.setTranslation(tr);
                }
                ++n2;
            }
        }
    }

    public synchronized ArrayList<PhysicalController> getControllers() {
        return this.controllers;
    }

    public VJoint getVNext() {
        return this.vNext;
    }

    public VJoint getVPrev() {
        return this.vPrev;
    }

    public VJoint getVCurr() {
        return this.vCurr;
    }

    public VJoint getVPredict() {
        return this.vPredict;
    }

    public synchronized PhysicalHumanoid getPHuman() {
        return this.pHuman;
    }

    public synchronized float getStepTime() {
        return this.stepTime;
    }

    public synchronized void clearAll(double time) {
        this.app.clearAll(time);
        if (this.appPredict != null) {
            this.appPredict.clearAll(time);
        }
    }

    public ArrayList<MixedSystem> getMixedSystems() {
        return this.mSystems;
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.app.setBMLBlockState(bmlId, state);
        this.appPredict.setBMLBlockState(bmlId, state);
    }

    @Override
    public double getEndTime(String behId, String bmlId) {
        return this.app.getEndTime(behId, bmlId);
    }

    @Override
    public Set<String> getBehaviours(String bmlId) {
        return this.app.getBehaviours(bmlId);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.app.interruptBehaviourBlock(bmlId, time);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        this.app.setParameterValue(behId, bmlId, paramId, value);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        this.app.setParameterValue(behId, bmlId, paramId, value);
    }

    @Override
    public void shutdown() {
    }
}

