/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.HeadBehaviour;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.AnimationPlanner;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class AnimationPlannerTest {
    @Mocked
    AnimationPlayer mockPlayer;
    @Mocked
    GestureBinding mockBinding;
    @Mocked
    SpeechBinding mockSBinding;
    @Mocked
    MotionUnit mockUnit;

    @Test
    public void testUnknownStart() throws BehaviourPlanningException {
        AnimationPlanner ap = new AnimationPlanner(this.mockPlayer, this.mockBinding, this.mockSBinding);
        BMLBlockPeg bbPeg = new BMLBlockPeg("Peg1", 0.3);
        HeadBehaviour beh = new HeadBehaviour();
        beh.readXML("<head id=\"nod1\" action=\"ROTATION\" rotation=\"NOD\"/>");
        beh.bmlId = "bml1";
        HeadBehaviour behF = beh;
        TimedMotionUnit tmu = new TimedMotionUnit(bbPeg, "nod1", "bml1", this.mockUnit);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg sp = new TimePeg(bbPeg);
        sacs.add(new TimePegAndConstraint("start", sp, new Constraint(), 0.0, false));
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        ArrayList<TimedMotionUnit> tmus = new ArrayList<TimedMotionUnit>();
        tmus.add(tmu);
        new NonStrictExpectations(bbPeg, behF, tmus, keyPos, start, end){
            {
                AnimationPlannerTest.this.mockBinding.getMotionUnit(bMLBlockPeg, (Behaviour)headBehaviour, AnimationPlannerTest.this.mockPlayer);
                this.returns(list);
                AnimationPlannerTest.this.mockUnit.getPreferedDuration();
                this.returns(3.0);
                AnimationPlannerTest.this.mockUnit.getKeyPositions();
                this.returns(list2);
                AnimationPlannerTest.this.mockUnit.getKeyPosition("start");
                this.returns(keyPosition);
                AnimationPlannerTest.this.mockUnit.getKeyPosition("end");
                this.returns(keyPosition2);
            }
        };
        TimedPlanUnit pu = ap.resolveSynchs(bbPeg, (Behaviour)beh, sacs);
        Assert.assertEquals((double)0.3, (double)sp.getGlobalValue(), (double)1.0E-4);
        ap.addBehaviour(bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((double)0.3, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)3.3, (double)pu.getEndTime(), (double)1.0E-4);
    }

    @Test
    public void testInterrupt() {
    }
}

