/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.GazeBehaviour;
import hmi.bml.core.GestureBehaviour;
import hmi.bml.core.HeadBehaviour;
import hmi.bml.core.PostureBehaviour;
import hmi.bml.ext.bmlt.BMLTControllerBehaviour;
import hmi.bml.ext.bmlt.BMLTKeyframeBehaviour;
import hmi.bml.ext.bmlt.BMLTProcAnimationBehaviour;
import hmi.bml.ext.bmlt.BMLTTransitionBehaviour;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AnimationPlanner
extends AbstractPlanner {
    private AnimationPlayer player;
    private GestureBinding gestureBinding;
    private SpeechBinding speechBinding;

    public AnimationPlanner(AnimationPlayer p, GestureBinding g, SpeechBinding s) {
        this.gestureBinding = g;
        this.speechBinding = s;
        this.player = p;
    }

    public void setGestureBinding(GestureBinding g) {
        this.gestureBinding = g;
    }

    public void setSpeechBinding(SpeechBinding s) {
        this.speechBinding = s;
    }

    public boolean hasSpeechBinding() {
        return this.speechBinding != null;
    }

    public TimedMotionUnit getSpeechMotionUnit(int visime, BMLBlockPeg bbPeg, String id, String bmlId) {
        return this.speechBinding.getMotionUnit(visime, bbPeg, id, bmlId, this.player);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public AnimationPlayer getAnimationPlayer() {
        return this.player;
    }

    public void addVisemesForSpeechUnit(List<TimedMotionUnit> visemeMUs) {
        for (TimedMotionUnit tmu : visemeMUs) {
            tmu.setSubUnit(true);
            this.player.addTimedMotionUnit(tmu);
        }
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedPlanUnit planElement) throws BehaviourPlanningException {
        TimedMotionUnit tmu;
        ArrayList<SyncAndTimePeg> satps = new ArrayList<SyncAndTimePeg>();
        if (planElement == null) {
            List<TimedMotionUnit> tmus = this.gestureBinding.getMotionUnit(bbPeg, b, this.player);
            if (tmus.isEmpty()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the gesture binding, behavior omitted.");
            }
            tmu = tmus.get(0);
        } else {
            tmu = (TimedMotionUnit)planElement;
        }
        tmu.resolveDefaultBMLKeyPositions();
        this.linkSynchs(tmu, sacs);
        for (BMLFeedbackListener fb : this.getFeedbackListeners()) {
            tmu.addFeedbackListener(fb);
        }
        this.player.addTimedMotionUnit(tmu);
        for (KeyPosition kp : tmu.getPegs().keySet()) {
            TimePeg p = tmu.getPegs().get(kp);
            satps.add(new SyncAndTimePeg(kp.id, b.id, b.bmlId, p));
        }
        return satps;
    }

    @Override
    public TimedMotionUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        List<TimedMotionUnit> tmus = this.gestureBinding.getMotionUnit(bbPeg, b, this.player);
        if (tmus.isEmpty()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the gesture binding, behavior omitted.");
        }
        TimedMotionUnit tmu = tmus.get(0);
        tmu.resolveDefaultBMLKeyPositions();
        ArrayList<TimePegAndConstraint> sortedSac = new ArrayList<TimePegAndConstraint>();
        block0: for (KeyPosition kp : tmu.getMotionUnit().getKeyPositions()) {
            for (TimePegAndConstraint s : sac) {
                if (!s.id.equals(kp.id)) continue;
                sortedSac.add(s);
                continue block0;
            }
        }
        this.linkSynchs(tmu, sortedSac);
        int sections = 0;
        double totalStretch = 0.0;
        TimePegAndConstraint sPrev = null;
        for (TimePegAndConstraint s : sortedSac) {
            if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            if (sPrev != null) {
                double duration = tmu.getTime(s.id) - tmu.getTime(sPrev.id);
                double startKey = 0.0;
                double endKey = 0.0;
                for (KeyPosition kp : tmu.getPegs().keySet()) {
                    if (tmu.getPegs().get(kp).getLink() == sPrev.peg.getLink()) {
                        startKey = kp.time;
                    }
                    if (tmu.getPegs().get(kp).getLink() != s.peg.getLink()) continue;
                    endKey = kp.time;
                }
                double nominalDuration = (endKey - startKey) * tmu.getMotionUnit().getPreferedDuration();
                if (!(nominalDuration > 0.0)) continue;
                totalStretch += duration / nominalDuration;
                ++sections;
                continue;
            }
            sPrev = s;
        }
        double avgStretch = 1.0;
        if (sections > 0) {
            avgStretch = totalStretch / (double)sections;
        }
        if (sortedSac.size() > 0) {
            TimePegAndConstraint sacStart = sortedSac.get(0);
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacNext = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacNext = s;
                    break;
                }
                if (sacNext == null) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    double nextKey = tmu.getKeyPosition((String)sacNext.id).time;
                    double nextTime = tmu.getTime(sacNext.id);
                    double tStart = nextTime - nextKey * avgStretch * tmu.getMotionUnit().getPreferedDuration();
                    if (sacStart.resolveAsStartOffset) {
                        OffsetPeg os = (OffsetPeg)sacStart.peg;
                        os.setLink(tmu.getTimePeg(sacNext.id));
                        os.setOffset(tStart - nextTime);
                    } else {
                        sacStart.peg.setGlobalValue(tStart + sacStart.offset);
                    }
                }
            }
            TimePegAndConstraint sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacPrev = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacPrev = s;
                }
                if (sacPrev == null) {
                    sacEnd.peg.setGlobalValue(tmu.getMotionUnit().getPreferedDuration());
                } else {
                    double keyPrev = tmu.getKeyPosition((String)sacPrev.id).time;
                    double keyNext = 1.0;
                    double keyCurr = tmu.getKeyPosition((String)sacEnd.id).time;
                    double timePrev = tmu.getTime(sacPrev.id);
                    double timeNext = timePrev + (keyNext - keyPrev) * avgStretch * tmu.getMotionUnit().getPreferedDuration();
                    sacEnd.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + sacEnd.offset);
                }
            }
            TimePegAndConstraint sacPrev = sacStart;
            TimePegAndConstraint sacNext = null;
            for (TimePegAndConstraint s : sortedSac) {
                if (s.peg.getGlobalValue() == -1.7976931348623157E308) {
                    for (TimePegAndConstraint s2 : sortedSac.subList(sortedSac.indexOf(s), sortedSac.size())) {
                        if (s2.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                        sacNext = s2;
                        break;
                    }
                    double keyPrev = tmu.getKeyPosition((String)sacPrev.id).time;
                    double keyNext = tmu.getKeyPosition((String)sacNext.id).time;
                    double keyCurr = tmu.getKeyPosition((String)s.id).time;
                    double timePrev = tmu.getTime(sacPrev.id);
                    double timeNext = tmu.getTime(sacNext.id);
                    s.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + s.offset);
                }
                sacPrev = s;
            }
            sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (!sacEnd.id.equals("end") && tmu.getMotionUnit().getPreferedDuration() > 0.0) {
                double keyPrev = tmu.getKeyPosition((String)sacEnd.id).time;
                double keyEnd = tmu.getKeyPosition((String)"end").time;
                OffsetPeg op = new OffsetPeg(tmu.getTimePeg(sacEnd.id), (keyEnd - keyPrev) * avgStretch * tmu.getMotionUnit().getPreferedDuration());
                tmu.setTimePeg(tmu.getKeyPosition("end"), (TimePeg)op);
            }
        }
        return tmu;
    }

    @Override
    public void clearAll(double time) {
        this.player.clearAll(time);
    }

    private void linkSynchs(TimedMotionUnit tmu, List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (KeyPosition kp : tmu.getMotionUnit().getKeyPositions()) {
                if (!s.id.equals(kp.id)) continue;
                if (s.offset == 0.0) {
                    tmu.setTimePeg(kp, s.peg);
                    continue;
                }
                tmu.setTimePeg(kp, (TimePeg)new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.interruptTimedMotionUnit(behaviourId, BMLId, 0.0);
    }

    @Override
    public void interruptBehaviour(String behaviourId, String BMLId, double globalTime) {
        this.player.interruptTimedMotionUnit(behaviourId, BMLId, globalTime);
    }

    @Override
    public Set<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviors();
    }

    @Override
    public void addExceptionListener(BMLExceptionListener war) {
        this.player.addExceptionListener(war);
    }

    @Override
    public void removeAllExceptionListeners() {
        this.player.removeAllExceptionListeners();
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(HeadBehaviour.class);
        list.add(GazeBehaviour.class);
        list.add(GestureBehaviour.class);
        list.add(PostureBehaviour.class);
        list.add(BMLTProcAnimationBehaviour.class);
        list.add(BMLTControllerBehaviour.class);
        list.add(BMLTTransitionBehaviour.class);
        list.add(BMLTKeyframeBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTProcAnimationBehaviour.class);
        list.add(BMLTControllerBehaviour.class);
        list.add(BMLTTransitionBehaviour.class);
        list.add(BMLTKeyframeBehaviour.class);
        return list;
    }

    @Override
    public void reset() {
        this.player.reset();
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
    }
}

