/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.animationengine.transitions.TransitionMU;
import hmi.elckerlyc.animationengine.transitions.TransitionTMU;
import hmi.elckerlyc.planunit.PUExceptionCallback;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import java.util.List;
import mockit.Delegate;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import mockit.Verifications;
import org.junit.Assert;
import org.junit.Test;

public class AnimationPlanPlayerTest {
    @Mocked
    MotionUnit muMock1;
    @Mocked
    MotionUnit muMock2;
    @Mocked
    TransitionMU muMockTransition;

    @Test
    public void testPlayTmu() throws MUPlayException {
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        TimedMotionUnit tmu1 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock1);
        tmu1.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu1);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        new NonStrictExpectations(start, end, keyPos){
            {
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("end");
                this.returns(keyPosition2);
                AnimationPlanPlayerTest.this.muMock1.play(0.0);
                times = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPositions();
                this.returns(list);
            }
        };
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        tmu1.setTimePeg("start", tpStart);
        tmu1.setState(TimedPlanUnitState.LURKING);
        app.play(0.0);
        Assert.assertTrue((tmu1.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPlayTmuPastEnd() throws MUPlayException {
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        TimedMotionUnit tmu1 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock1);
        tmu1.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu1);
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MyWarningCallback wc = new MyWarningCallback(warnings);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        new NonStrictExpectations(start, end, keyPos){
            {
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("end");
                this.returns(keyPosition2);
                AnimationPlanPlayerTest.this.muMock1.getKeyPositions();
                this.returns(list);
                AnimationPlanPlayerTest.this.muMock1.play(anyDouble);
                times = 1;
            }
        };
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        tmu1.setTimePeg("start", tpStart);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(1.0);
        tmu1.setTimePeg("end", tpEnd);
        tmu1.setState(TimedPlanUnitState.LURKING);
        app.play(0.99, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tmu1.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.99 ? 1 : 0) != 0);
        app.play(2.0, wc);
        Assert.assertTrue((tmu1.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.99 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)1)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)1)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)1)).syncId.equals("end"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)1)).timeStamp == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPlay2Tmu() throws MUPlayException {
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        TimedMotionUnit tmu1 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock1);
        tmu1.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu1);
        TimedMotionUnit tmu2 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour2", "bml1", this.muMock2);
        tmu2.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu2);
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MyWarningCallback wc = new MyWarningCallback(warnings);
        KeyPosition start1 = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end1 = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos1 = new ArrayList<KeyPosition>();
        keyPos1.add(start1);
        keyPos1.add(end1);
        KeyPosition start2 = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end2 = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos2 = new ArrayList<KeyPosition>();
        keyPos2.add(start2);
        keyPos2.add(end2);
        new NonStrictExpectations(start1, end1, keyPos1, start2, end2, keyPos2){
            {
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("end");
                this.returns(keyPosition2);
                AnimationPlanPlayerTest.this.muMock1.play(0.0);
                times = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPositions();
                this.returns(list);
                AnimationPlanPlayerTest.this.muMock2.getKeyPosition("start");
                this.returns(keyPosition3);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock2.getKeyPosition("end");
                this.returns(keyPosition4);
                AnimationPlanPlayerTest.this.muMock2.play(anyDouble);
                times = 1;
                AnimationPlanPlayerTest.this.muMock2.getKeyPositions();
                this.returns(list2);
            }
        };
        TimePeg tpStart1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart1.setGlobalValue(0.0);
        TimePeg tpStart2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart2.setGlobalValue(2.0);
        tmu1.setTimePeg("start", tpStart1);
        tmu1.setTimePeg("end", tpStart2);
        tmu2.setTimePeg("start", tpStart2);
        tmu1.setState(TimedPlanUnitState.LURKING);
        tmu2.setState(TimedPlanUnitState.LURKING);
        app.play(0.0, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tmu1.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((tmu2.getState() == TimedPlanUnitState.LURKING ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.0 ? 1 : 0) != 0);
        app.play(2.1, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tmu1.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
        Assert.assertTrue((tmu2.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)1)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)1)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)1)).syncId.equals("end"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)1)).timeStamp == 2.1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)2)).behaviorId.equals("behaviour2"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)2)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)2)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)2)).timeStamp == 2.1 ? 1 : 0) != 0);
    }

    @Test
    public void testTransitionTMU() {
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        TransitionTMU tmu = new TransitionTMU(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMockTransition);
        app.addPlanUnit(tmu);
        tmu.addFeedbackListener((BMLFeedbackListener)fbl);
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MyWarningCallback wc = new MyWarningCallback(warnings);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        new NonStrictExpectations(start, end, keyPos){
            {
                AnimationPlanPlayerTest.this.muMockTransition.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMockTransition.getKeyPosition("end");
                this.returns(keyPosition2);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMockTransition.play(this.withEqual(0.5, 0.01));
                times = 1;
                AnimationPlanPlayerTest.this.muMockTransition.setStartPose();
                times = 1;
                AnimationPlanPlayerTest.this.muMockTransition.getKeyPositions();
                this.returns(list);
            }
        };
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(1.0);
        tmu.setTimePeg("start", tpStart);
        tmu.setTimePeg("end", tpEnd);
        tmu.setState(TimedPlanUnitState.LURKING);
        app.play(0.5, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tmu.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.5 ? 1 : 0) != 0);
        app.play(0.6, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((tmu.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
    }

    @Test
    public void testTMU() throws MUPlayException {
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MyWarningCallback wc = new MyWarningCallback(warnings);
        TimedMotionUnit tmu = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock1);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(1.0);
        tmu.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        new NonStrictExpectations(start, end, keyPos){
            {
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("end");
                this.returns(keyPosition2);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.play(this.withEqual(0.5, 0.01));
                times = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPositions();
                this.returns(list);
            }
        };
        tmu.setTimePeg("start", tpStart);
        tmu.setTimePeg("end", tpEnd);
        tmu.setState(TimedPlanUnitState.LURKING);
        app.play(0.5, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tmu.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.5 ? 1 : 0) != 0);
    }

    @Test
    public void testFailingTMU() throws MUPlayException {
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MyWarningCallback wc = new MyWarningCallback(warnings);
        TimedMotionUnit tmu = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock1);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        TimePeg tpEnd = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd.setGlobalValue(1.0);
        tmu.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos = new ArrayList<KeyPosition>();
        keyPos.add(start);
        keyPos.add(end);
        new NonStrictExpectations(start, end, keyPos){
            {
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("end");
                this.returns(keyPosition2);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.play(this.withEqual(0.5, 0.01));
                result = new Delegate(){

                    public void play(double time) throws MUPlayException {
                        throw new MUPlayException("failure!", (this).AnimationPlanPlayerTest.this.muMock1);
                    }
                };
                times = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPositions();
                this.returns(list);
            }
        };
        tmu.setTimePeg("start", tpStart);
        tmu.setTimePeg("end", tpEnd);
        tmu.setState(TimedPlanUnitState.LURKING);
        app.play(0.5, wc);
        Assert.assertTrue((warnings.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((Warning)warnings.get((int)0)).pu, (Object)tmu);
        Assert.assertTrue((tmu.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
    }

    @Test
    public void testPlay2FullyOverlappingTmus() throws MUPlayException {
        int muMock2PlayTimes;
        int muMock1PlayTimes;
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        TimedMotionUnit tmu1 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock1);
        tmu1.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu1);
        TimedMotionUnit tmu2 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour2", "bml1", this.muMock2);
        tmu2.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu2);
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MyWarningCallback wc = new MyWarningCallback(warnings);
        KeyPosition start1 = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end1 = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos1 = new ArrayList<KeyPosition>();
        keyPos1.add(start1);
        keyPos1.add(end1);
        KeyPosition start2 = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end2 = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos2 = new ArrayList<KeyPosition>();
        keyPos2.add(start2);
        keyPos2.add(end2);
        new NonStrictExpectations(start1, end1, keyPos1, start2, end2, keyPos2){
            {
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("end");
                this.returns(keyPosition2);
                AnimationPlanPlayerTest.this.muMock1.getReplacementGroup();
                this.returns("rep1");
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPositions();
                this.returns(list);
                AnimationPlanPlayerTest.this.muMock2.getKeyPosition("start");
                this.returns(keyPosition3);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock2.getKeyPosition("end");
                this.returns(keyPosition4);
                AnimationPlanPlayerTest.this.muMock2.getReplacementGroup();
                this.returns("rep1");
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock2.getKeyPositions();
                this.returns(list2);
            }
        };
        TimePeg tpStart1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart1.setGlobalValue(0.0);
        TimePeg tpStart2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart2.setGlobalValue(0.0);
        tmu1.setTimePeg("start", tpStart1);
        tmu2.setTimePeg("start", tpStart2);
        tmu1.setState(TimedPlanUnitState.LURKING);
        tmu2.setState(TimedPlanUnitState.LURKING);
        app.play(0.0, wc);
        Assert.assertTrue((warnings.size() == 1 ? 1 : 0) != 0);
        Warning w = (Warning)warnings.get(0);
        TimedMotionUnit tmuSucceed = tmu1;
        if (w.pu == tmu1) {
            tmuSucceed = tmu2;
        }
        Assert.assertTrue((tmuSucceed.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((w.pu.getState() == TimedPlanUnitState.LURKING ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals(tmuSucceed.getId()));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals(tmuSucceed.getBMLId()));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.0 ? 1 : 0) != 0);
        if (tmuSucceed.getMotionUnit() == this.muMock1) {
            muMock1PlayTimes = 1;
            muMock2PlayTimes = 0;
        } else {
            muMock2PlayTimes = 1;
            muMock1PlayTimes = 0;
        }
        new Verifications(muMock1PlayTimes, muMock2PlayTimes){
            {
                AnimationPlanPlayerTest.this.muMock1.play(0.0);
                times = n;
                AnimationPlanPlayerTest.this.muMock2.play(0.0);
                times = n2;
            }
        };
    }

    @Test
    public void testPlay2OverlappingTmus() throws MUPlayException {
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        PlanPlayer app = new PlanPlayer();
        TimedMotionUnit tmu1 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour1", "bml1", this.muMock1);
        tmu1.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu1);
        TimedMotionUnit tmu2 = new TimedMotionUnit(BMLBlockPeg.GLOBALPEG, "behaviour2", "bml1", this.muMock2);
        tmu2.addFeedbackListener((BMLFeedbackListener)fbl);
        app.addPlanUnit(tmu2);
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MyWarningCallback wc = new MyWarningCallback(warnings);
        KeyPosition start1 = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end1 = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos1 = new ArrayList<KeyPosition>();
        keyPos1.add(start1);
        keyPos1.add(end1);
        KeyPosition start2 = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end2 = new KeyPosition("end", 1.0, 1.0);
        ArrayList<KeyPosition> keyPos2 = new ArrayList<KeyPosition>();
        keyPos2.add(start2);
        keyPos2.add(end2);
        new NonStrictExpectations(start1, end1, keyPos1, start2, end2, keyPos2){
            {
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("start");
                this.returns(keyPosition);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPosition("end");
                this.returns(keyPosition2);
                AnimationPlanPlayerTest.this.muMock1.play(0.0);
                times = 1;
                AnimationPlanPlayerTest.this.muMock1.getReplacementGroup();
                this.returns("rep1");
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock1.getKeyPositions();
                this.returns(list);
                AnimationPlanPlayerTest.this.muMock2.getKeyPosition("start");
                this.returns(keyPosition3);
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock2.getKeyPosition("end");
                this.returns(keyPosition4);
                AnimationPlanPlayerTest.this.muMock2.play(0.0);
                times = 1;
                AnimationPlanPlayerTest.this.muMock2.getReplacementGroup();
                this.returns("rep1");
                minTimes = 1;
                AnimationPlanPlayerTest.this.muMock2.getKeyPositions();
                this.returns(list2);
            }
        };
        TimePeg tpStart1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart1.setGlobalValue(0.0);
        TimePeg tpStart2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart2.setGlobalValue(0.0);
        TimePeg tpEnd2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpEnd2.setGlobalValue(1.0);
        tmu1.setTimePeg("start", tpStart1);
        tmu2.setTimePeg("start", tpStart2);
        tmu2.setTimePeg("end", tpEnd2);
        tmu1.setState(TimedPlanUnitState.LURKING);
        tmu2.setState(TimedPlanUnitState.LURKING);
        app.play(0.0, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tmu1.getState() == TimedPlanUnitState.LURKING ? 1 : 0) != 0);
        Assert.assertTrue((tmu2.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).behaviorId.equals("behaviour2"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)0)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)0)).timeStamp == 0.0 ? 1 : 0) != 0);
        app.play(2.0, wc);
        Assert.assertTrue((warnings.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((tmu2.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
        Assert.assertTrue((tmu1.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 3 ? 1 : 0) != 0);
        int i1 = 1;
        int i2 = 2;
        if (((BMLSyncPointProgressFeedback)fbList.get((int)1)).behaviorId.equals("behaviour1")) {
            i1 = 1;
            i2 = 2;
        } else if (((BMLSyncPointProgressFeedback)fbList.get((int)1)).behaviorId.equals("behaviour2")) {
            i1 = 2;
            i2 = 1;
        } else {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)i1)).behaviorId.equals("behaviour1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)i1)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)i1)).syncId.equals("start"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)i1)).timeStamp == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)i2)).behaviorId.equals("behaviour2"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)i2)).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)((BMLSyncPointProgressFeedback)fbList.get((int)i2)).syncId.equals("end"));
        Assert.assertTrue((((BMLSyncPointProgressFeedback)fbList.get((int)i2)).timeStamp == 2.0 ? 1 : 0) != 0);
    }

    private static class MyWarningCallback
    implements PUExceptionCallback {
        private List<Warning> warnings;

        public MyWarningCallback(List<Warning> w) {
            this.warnings = w;
        }

        @Override
        public void puException(TimedPlanUnit tmu, String message, double time) {
            this.warnings.add(new Warning(tmu, message));
        }
    }

    private static class Warning {
        public final TimedPlanUnit pu;

        public Warning(TimedPlanUnit pu, String message) {
            this.pu = pu;
        }
    }
}

